@extends ('../welcome')
@section('content')
    <link rel="stylesheet" href="{{ asset('swiper/swiper.css') }}">

    <style>
        .clickable-row:hover {
            background-color: gray;
            color: white;
            cursor: pointer;
        }

        .fade:not(.show){
            opacity: 1 !important;
        }

        a:hover {
            cursor: pointer;

        }

        .tabcontent {
            display: none;
        }

        .tabcontent.active {
            display: block;
        }

        #upload-photo {
            display: none;
        }

        #upload-file {
            display: none;
        }

        .card {
            height: -webkit-fill-available;
        }

        #carouselExampleControls .btn {
            position: absolute;
            top: 0%;
            right: 0%;
            background-color: transparent;

            opacity: 0.5;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: grey;


        }

        .w-100 {
            height: 400px !important
        }

        #carouselExampleControls .btn:hover {
            background-color: transparent;
            opacity: 3.0;
            color: white;
        }

        /* swiper ////////////////////////////////////*/
        .swiper {
            width: 240px;
            height: 320px;
        }

        .swiper .swiper-slide {
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 18px;
            font-size: 22px;
            font-weight: bold;
            color: #fff;
        }

        .swiper2 {
            width: 100%;
            padding-top: 50px;
            padding-bottom: 50px;
        }

        .swiper2 .swiper-slide {
            background-position: center;
            background-size: cover;
            width: 300px;
            height: 300px;
        }

        .swiper2 .swiper-slide img {
            display: block;
            width: 100%;
        }

        td {
            font-size: 20px;
        }
    </style>
    <div class="card">
        <div class="card-header">
            <div class="tab">
                <button id="autoClick" class="tablinks btn btn-outline-info" onclick="openCity(event, 'Data')">Data</button>
                <button class="tablinks btn btn-outline-success" onclick="openCity(event, 'Agents')">Agents</button>
                <button class="tablinks btn btn-outline-secondary" onclick="openCity(event, 'Analysis')">Analysis</button>
                <button class="tablinks btn btn-outline-warning" onclick="openCity(event, 'History')">History</button>
                <button class="tablinks btn btn-outline-dark" onclick="openCity(event, 'Activities')">Activities</button>
            </div>
        </div>
        <div class="card-body">
            <div id="Data" class="tabcontent active">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-info card-outline">
                            <div class="card-header">
                                <div class="row">
                                    <form action="{{ route('BrokerfileUpload') }}" method="POST"
                                        enctype="multipart/form-data" class="col-10">
                                        @csrf
                                        <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                                            <i class="fas fa-file-image"></i> &nbsp;
                                            <i class="fas fa-upload"></i>
                                        </label>
                                        <input type="file" name="images[]" id="upload-photo" multiple>
                                        <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                                            <i class="fas fa-file-pdf"></i> &nbsp;
                                            <i class="fas fa-upload"></i>
                                        </label>
                                        <input type="file" name="files[]" id="upload-file" multiple>

                                        <input type="hidden" value="{{ $broker->id }}" name="broker_id">

                                        <button type="submit" title="upload" style="margin-bottom:10px;"
                                            class="btn btn-outline-info"><i class="fas fa-check"></i></button>
                                    </form>
                                    <a href="{{ route('brokers.edit', $broker->id) }}">
                                        <button class="btn btn-square btn-outline-info" title=" Edit Broker" type="button">
                                            <i class="fas fa-pen"></i>
                                        </button>
                                    </a>
                                    @if ($broker->status == 'pending')
                                        <form method="post" action="{{ route('brokerStatus') }}">
                                            @csrf
                                            <input type="hidden" value="accepted" name="status">
                                            <input type="hidden" value="{{$broker->id}}" name="broker_id">
                                            <button class="btn btn-square btn-outline-success" title="Confirm"
                                                type="submit">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form method="post" action="{{ route('brokerStatus') }}">
                                            @csrf
                                            <input type="hidden" value="{{$broker->id}}" name="broker_id">
                                            <input type="hidden" value="rejected" name="status">
                                            <button class="btn btn-square btn-outline-danger" title="Reject" type="submit">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <table class="col-7">
                                        <tbody>
                                            <tr>
                                                <th>Name :</th>
                                                <td>{{ $broker->name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Email :</th>
                                                <td>{{ $broker->email ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Address :</th>
                                                <td>{{ $broker->address ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Sales Man :</th>
                                                <td>{{ $broker->salesMan?->name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Type :</th>
                                                <td>{{ $broker->type ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Owner Name :</th>
                                                <td>{{ $broker->owner_name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Sales Admin :</th>
                                                <td>{{ $broker->sales_admin ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Authorized Name :</th>
                                                <td>{{ $broker->authorized_name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Sales Admin :</th>
                                                <td>{{ $broker->sales_admin ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Commercial Record :</th>
                                                <td>{{ $broker->commercial_record ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Description :</th>
                                                <td>{{ $broker->description ?? '-' }}</td>
                                            </tr>
                                            @if ($broker->has_contract == 1)
                                                <tr>
                                                    <th>has Contract :</th>
                                                    <td>yes</td>
                                                </tr>
                                                <tr>
                                                    <th>Commission :</th>
                                                    <td>{{ $broker->commission ?? '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Contract StartDate:</th>
                                                    <td>{{ $broker->contract_startDate ?? '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Contract End Date:</th>
                                                    <td>{{ $broker->contract_endDate ?? '-' }}</td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                    <div class="col-5">
                                        @if (Auth::user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('brokers-PhoneNumber'))
                                            @if (Auth::user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('brokers-create-PhoneNumber'))
                                                <button type="button" class="btn btn-" style="color:#dc3545"
                                                    title="add new number" data-toggle="modal" data-target="#storePhones">
                                                    <i class="fas fa-phone"></i>
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @endif
                                            <div class="card card-danger card-outline">
                                                <div class="card-body table-responsive p-0">
                                                    <table class="table table-hover text-nowrap">
                                                        <tbody>
                                                            @forelse($broker->phone_numbers as $phone)
                                                                <tr>
                                                                    <td>
                                                                        <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                                                            {{ $phone->country->phonecode }}
                                                                            {{ $phone->phone }}
                                                                        </a>
                                                                    </td>
                                                                    <td>
                                                                        @if (Auth::user()->type == 'admin' ||
                                                                                auth()->user()->role->hasPermission('brokers-edit-PhoneNumber'))
                                                                            <a class="btn btn-light"
                                                                                href="{{ route('phones.edit', $phone->id) }}">
                                                                                <i class="fas fa-pen"
                                                                                    style="color:#17a2b8"></i>
                                                                            </a>
                                                                        @endif
                                                                        @if (Auth::user()->type == 'admin' ||
                                                                                auth()->user()->role->hasPermission('brokers-delete-PhoneNumber'))
                                                                            @if (count($broker->phone_numbers) > 1)
                                                                                <button onClick="clickDeletePhone(this)"
                                                                                    title="Delete" type="button"
                                                                                    style="height:38px;"
                                                                                    class="btn btn-light"
                                                                                    data-id="{{ $phone->id }}"
                                                                                    data-toggle="modal"
                                                                                    data-target="#phoneDelete">
                                                                                    <i class="fa fa-trash"
                                                                                        style="color:#dc3545"></i>
                                                                                </button>
                                                                            @endif
                                                                        @endif
                                                                    </td>
                                                                </tr>
                                                            @empty
                                                                <p>No Phone number Available for this Broker</p>
                                                            @endforelse
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div class="card card-info card-outline">
                                                <div class="card-body table-responsive p-0">
                                                    <table class="table table-hover text-nowrap">
                                                        <tbody>
                                                            <form action="{{route('brokerReAssign')}}" method="post">
                                                                <input type="hidden" name="broker_id" value="{{$broker->id}}">
                                                                @csrf
                                                                <tr>
                                                                    <th>Re-Assign</th>
                                                                    <td>
                                                                        <select name="user_id" id="user" class="select2 custom-select form-control-border">
                                                                            @foreach($users as $user)
                                                                            <option value="{{$user->id}}" {{$user->id == $broker->user_id ? 'selected' : ''}}>{{$user->name}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <button type="submit" class="btn btn-outline-info">
                                                                            <i class="fas fa-check"></i>
                                                                        </button>
                                                                    </td>
                                                                </tr>
                                                            </form>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        @endif
                                        @if (count($broker->files) != 0)
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('brokers-files'))
                                                <div class="card collapsed-card">
                                                    <div class="card-header" data-card-widget="collapse">
                                                        <h3 class="card-title">
                                                            Files
                                                        </h3>
                                                    </div>
                                                    <div class="card-body">
                                                        <table class="table table-bordered">
                                                            @foreach ($broker->files as $file)
                                                                <tr>
                                                                    <td>
                                                                        <a
                                                                            href="{{ URL::to('/') }}/files/{{ $file->file }}">{{ $file->file }}-{{ $file->created_at }}</a>
                                                                    </td>
                                                                    <td>
                                                                        <form method="POST"
                                                                            action="{{ route('files.destroy', $file->id) }}">
                                                                            @csrf
                                                                            @method('DELETE')
                                                                            <button type="submit"
                                                                                class="btn btn-outline-danger">
                                                                                <i class="fas fa-trash"></i>
                                                                            </button>
                                                                        </form>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </table>
                                                    </div>
                                                </div>
                                            @endif
                                        @endif
                                        <!-- Swiper -->
                                        @if (count($broker->images) != 0)
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('brokers-images'))
                                            <div class="card collapsed-card">
                                                <div class="card-header" data-card-widget="collapse">
                                                    <h3 class="card-title">
                                                        Images
                                                    </h3>
                                                </div>
                                                <div class="card-body">
                                                    <div class="swiper mySwiper" id="mySwiper" data-toggle="modal"
                                                        data-target="#imageGallery">
                                                        <div class="swiper-wrapper">
                                                            @foreach ($broker->images as $key => $value)
                                                                <div class="swiper-slide">
                                                                    <img class="swiper-slide"
                                                                        src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                                                        alt="{{ $value->name }}" />
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        @endif
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="Agents" class="tabcontent">
                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('agents-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered" style="margin: unset">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Created Date</th>
                            <th>Created Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($broker->agents as $agent)
                            <?php $temp = explode(' ', $agent->created_at->setTimezone('Africa/Cairo')); ?>
                            <tr>
                                <td>{{ $agent->id }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('agents-show'))
                                        <a href="{{ route('agents.show', $agent->id) }}">
                                            {{ $agent->name }}
                                        </a>
                                    @else
                                        {{ $agent->name }}
                                    @endif
                                </td>
                                <td>
                                    {{ $agent->email }}
                                </td>
                                <td>
                                    {{ $agent->phone }}
                                </td>
                                <td>{{ $temp[0] }}</td>
                                <td>{{ $temp[1] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div id="Analysis" class="tabcontent">
                <table id="analysis" class="table table-bordered" style="margin: unset">
                    <thead>
                        <tr>
                            <th>Agent ID</th>
                            <th>Agent Name</th>
                            <th>brokers</th>
                            <th>leads</th>
                            <th>Requests</th>
                            <th>Cils</th>
                            <th>done deals</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($broker->agents as $agent)
                            <?php $temp = explode(' ', $agent->created_at->setTimezone('Africa/Cairo')); ?>
                            <tr>
                                <td>{{ $agent->id }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('agents-show'))
                                        <a href="{{ route('agents.show', $agent->id) }}">
                                            {{ $agent->name }}
                                        </a>
                                    @else
                                        {{ $agent->name }}
                                    @endif
                                </td>
                                <td>
                                    {{ $agent->brokers->count() }}
                                </td>
                                <td>
                                    {{ $agent->leads->count() }}
                                </td>
                                <td>
                                    {{ $agent->inquiries->count() }}
                                </td>
                                <td>
                                    {{ $agent->inquiries->whereNotNull('lead_id')->count() }}
                                </td>
                                <td>
                                    {{ $agent->leads->whereNotNull('client_id')->count() }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div id="History" class="tabcontent">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">History</h3><br>
                        <p>Total: {{count($activities)}}</p>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="" class="table table-bordered ">
                            <thead>
                                <tr>
                                    <th>Log</th>
                                    <th>Event</th>
                
                                    <th>Causer</th>
                                    <th>Description</th>
                
                                    <th>Created Date</th>
                                    <th>Created Time</th>
                                </tr>
                            </thead>
                            <tbody>
                
                                @foreach ($activities as $activity)
                                {{-- {{$activity}} --}}
                                <?php $temp = explode(' ',$activity->created_at->setTimezone('Africa/Cairo'));?>
                
                
                                <tr class="activity" data-toggle="modal" data-target={{$activity->event == 'updated' ? '#'."$activity->id": ''}}
                                    class="modalData">
                                    <td> {{$activity->log_name}} </td>
                                    <td> {{$activity->event}} </td>
                                    <td> {{$activity->causer_type::find($activity->causer_id)->name;}} </td>
                                    <td> {{$activity->description}} </td>
                
                                    <td>{{$temp[0] ?? ''}}</td>
                                    <td>{{$temp[1] ?? ''}}</td>
                                </tr>
                                <!-- Delete Modal -->
                
                                <div class="modal fade" id={{$activity->id}} tabindex="-1" role="dialog" aria-labelledby="myModal"
                                    aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Log Details</h5>
                                                <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                                            </div>
                                            <div class="modal-body">
                                                <?php
                                                    $properties =  json_decode($activity->properties, true);
                                                    // print_r($properties);
                                                ?>
                                                @foreach($properties as $key => $value)
                                                
                                                @foreach($value as $keyy=>$vall)
                
                                                <div class="row">
                                                    @if($key == 'old')
                                                        Changed from
                                                        <label class="col-3">{{$keyy}} </label>                                                   
                                                        <label>
                                                            @if($keyy == 'user_id')
                                                            <label>
                                                                ({{'App\Models\User'::find($vall)?->name ?? ''}})
                                                            </label>
                                                        @else
                                                            <label>
                                                                ({{$vall ?? ''}})
                                                            </label>
                                                        @endif
                                                    @else
                                                        To
                                                        <label class="col-3"> {{$keyy}}</label>
                                                        
                                                        @if($keyy == 'user_id')
                                                            <label>
                                                                ({{'App\Models\User'::find($vall)?->name ?? ''}})
                                                            </label>
                                                        @else
                                                            <label>
                                                                ({{$vall ?? ''}})
                                                            </label>
                                                        @endif
                                                    @endif
                                                </div>
                
                                                @endforeach
                                                <hr>
                                                @endforeach
                                            </div>
                
                                        </div>
                                    </div>
                                </div>
                
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div id="Activities" class="tabcontent">
                <table id="activities" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Type</th>
                            <th>State</th>
                            <th>broker</th>
                            <th>Agent</th>
                            <th>check in</th>
                            <th>Creator</th>
                            <th>To Do Date</th>
                            <th>Close Date</th>
                            <th>Created at</th>
                            <th>Control</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($broker->communications as $communication)
                            @if ($communication->agent_id != null)
                                <tr>
                                    <td>{{ $communication->id }}</td>
                                    <td>
                                        {{ $communication->type ?? '' }}
                                    </td>
                                    <td>
                                        {{ $communication->state ?? '' }}
                                    </td>

                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('brokers-show'))
                                            <a href="{{ route('brokers.show', $communication->broker->id) }}">
                                                {{ $communication->broker->name ?? '' }}
                                            </a>
                                        @else
                                            <a>
                                                {{ $communication->broker->name ?? '' }}
                                            </a>
                                        @endif
                                    </td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('agents-show'))
                                            <a href="{{ route('agents.show', $communication->agent_id) }}">
                                                {{ $communication->agent->name ?? '' }}
                                            </a>
                                        @else
                                            <a>
                                                {{ $communication->agent->name ?? '' }}
                                            </a>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $communication->check_in == 0 ? 'no' : 'yes' }}
                                    </td>

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-show'))
                                        <td>
                                            <a href="{{ route('users.show', $communication->user->id) }}">
                                                {{ $communication->user?->name }}
                                            </a>
                                        </td>
                                    @else
                                        {{ $communication->user?->name ?? '' }}
                                    @endif

                                    <td>{{ $communication->event?->start }}</td>
                                    <td>{{ $communication->event?->end }}</td>
                                    <td>{{ $communication->created_at }}</td>

                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('communications-show'))
                                            <form action="" method="POST">
                                                <a class="btn btn-light" title="Show"
                                                    href="{{ route('communications.show', $communication->id) }}">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                                @csrf
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <!-- Delete Image from Slider Modal -->
    <div class="modal fade" id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this Image ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Store Phone Number -->
    <div class="modal fade" id="storePhones" tabindex="-1" role="dialog" aria-labelledby="storePhonesLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="storePhonesLabel">add new number</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('phones.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="broker_id" type="hidden" value="{{ $broker->id }}">
                        </div>
                        <div class="row">
                            <div class="form-group col-4">
                                <select class="form-control" name="country_id" required>
                                    <option></option>
                                    @foreach ($codes as $code)
                                        <option value="{{ $code->id }}"
                                            {{ $code->name == 'Egypt' ? 'selected' : '' }}>{{ $code->name }}
                                            +{{ $code->phonecode }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-8">
                                <input class="form-control" name="phone" type="text" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Phone Modal -->
    <div class="modal fade" id="phoneDelete" tabindex="-1" role="dialog" aria-labelledby="phoneDelete"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">

                <div class="modal-body">
                    <h5>Are you sure to delete this phone Number ?</h5>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <!-- gallery Image from Slider Modal -->
    <div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content"
                style="background-color: unset;box-shadow: unset; border: unset;">
                <div class="modal-body">
                    <div class="swiper2 mySwiper2">
                        <div class="swiper-wrapper">
                            @foreach ($broker->images as $key => $value)
                                <div class="swiper-slide">
                                    <img style="position: absolute"
                                        src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                        alt="{{ $value->name }}" />
                                    <a
                                        href="{{ route('broker.deleteImage', $value->id) }}">
                                        <button
                                            style="position: relative; float:right;color:white;font-size:30px"
                                            class="btn">×</button>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script type="module" src="{{ asset('swiper/swiper.js') }}"></script>

    <script>
let activity = document.querySelectorAll('.activity')
activity.forEach(a => {
a.addEventListener('click',()=>{
    console.log(a);
})
    
});

        function openCity(evt, cityName) {
            var i, tabcontent, tablinks;
            tabcontent = document.getElementsByClassName("tabcontent");
            for (i = 0; i < tabcontent.length; i++) {
                tabcontent[i].style.display = "none";
            }
            tablinks = document.getElementsByClassName("tablinks");
            for (i = 0; i < tablinks.length; i++) {
                tablinks[i].className = tablinks[i].className.replace(" active", "");
            }
            document.getElementById(cityName).style.display = "block";
            evt.currentTarget.className += " active";
        }

        // let autoClick = document.getElementById('autoClick');
        // autoClick.click();
        
        // Remove leading zeros from phone number input
        $(document).ready(function() {
            $('input[name="phone"]').on('input', function() {
                var phoneNumber = $(this).val();
                
                // Remove leading zeros but keep the value if it's just "0"
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            
            // Also handle on blur (when user leaves the field)
            $('input[name="phone"]').on('blur', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
        });
    </script>
@endsection
