@extends ('../welcome')

@section ('content')

<div class="card card-info">

    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('batches.store') }}" method="post">
            @csrf

            <div class="row">
                <div class="form-group col-7">
                    <label>unit</label>
                    <input type="text" class="form-control" value="{{$unit->name ?? ''}}" readonly>
                    <input type="hidden" name="unitId" value="{{$unit->id ?? ''}}">
                </div>
                <button id="addRow" title="add Type" type="button" class="btn btn-info"
                    style="height:40px; margin-top:30px;">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
            <div id="inputFormRow">
                <div class="row">
                    <div class="form-group col-2">
                        <label>Payment Type</label>
                        <select class="select2 custom-select form-control-border" name="title[]" required>
                            @foreach($paymentTypes as $type)
                            <option value="{{$type->name}}">{{$type->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-2">
                        <label>Type</label>
                        <select class="select2 custom-select form-control-border" name="type[]" required>
                            <option value="maintenance">Maintenance</option>
                            <option value="total_unit">Total Unit</option>
                        </select>
                    </div>
                    <div class="form-group col-1">
                        <label>Amount</label>
                        <input type="number" step="any" class="form-control" name="amount[]" placeholder="00" required>
                    </div>
                    <div class="form-group col-2">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date[]" required>
                    </div>
                </div>
                <div id="newRow"></div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
    <!-- /.card-body -->
</div>
<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
// add row
$("#addRow").click(function() {
    var html = '';
    html += `
    <div id="inputFormRow">
        <div class="row" style="margin-top:20px;">
        <div class="form-group col-2">
                <select class="select2 custom-select form-control-border" name="title[]" required>
                    @foreach($paymentTypes as $type)
                    <option value="{{$type->name}}">{{$type->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-2">
                <select class="select2 custom-select form-control-border" name="type[]" required>
                    <option value="maintenance">Maintenance</option>
                    <option value="total_unit">Total Unit</option>
                </select>
            </div>
            <div class="form-group col-1">
                <input type="number" step="any" class="form-control" name="amount[]" placeholder="00" required>
            </div>
            <div class="form-group col-2">
                <input type="date" class="form-control" name="date[]" required>
            </div>
            <div class="col-2" style="padding-top:35px;margin-top:-35px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

    $('#newRow').append(html);
});

// remove row
$(document).on('click', '#removeRow', function() {
    $(this).closest('#inputFormRow').remove();
});
</script>
@endsection