<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permessions = [
            ////////////////////// Users Permissions ///////////////////////////////////////// 
            [
                'name' => 'users-create',
                'display_name' => 'Create Users',
                'description' => 'Create Users',
                'type' => 'Users'
            ],
            [
                'name' => 'users-tree',
                'display_name' => 'Users Tree',
                'description' => 'Users Tree',
                'type' => 'Users'
            ],
            [
                'name' => 'users-blocklist',
                'display_name' => 'Users Blocklist',
                'description' => 'Users Blocklist',
                'type' => 'Users'
            ],
            [
                'name' => 'users-edit',
                'display_name' => 'Users Edit',
                'description' => 'Users Edit',
                'type' => 'Users'
            ],
            [
                'name' => 'users-block',
                'display_name' => 'Users Block',
                'description' => 'Users Block',
                'type' => 'Users'
            ],
            [
                'name' => 'users-export',
                'display_name' => 'Users Export',
                'description' => 'Users Export',
                'type' => 'Users'
            ],
            [
                'name' => 'users-show',
                'display_name' => 'Users Show',
                'description' => 'Users Show',
                'type' => 'Users'
            ],
            [
                'name' => 'users-read',
                'display_name' => 'Users Read',
                'description' => 'Users Read',
                'type' => 'Users'
            ],
            [
                'name' => 'users-assignPermissions',
                'display_name' => 'Users AssignPermissions',
                'description' => 'Users AssignPermissions',
                'type' => 'Users'
            ],
            [
                'name' => 'users-restore',
                'display_name' => 'Users Restore',
                'description' => 'Users Restore',
                'type' => 'Users'
            ],
            [
                'name' => 'users-restorAll',
                'display_name' => 'Users RestorAll',
                'description' => 'Users RestorAll',
                'type' => 'Users'
            ],

            /////////////////////////// Roles Permissions //////////////////////////////////////////
            [
                'name' => 'roles-create',
                'display_name' => 'Create Roles',
                'description' => 'Create Roles',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-tree',
                'display_name' => 'Roles Tree',
                'description' => 'Roles Tree',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-archive',
                'display_name' => 'Roles Archive',
                'description' => 'Roles Archive',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-edit',
                'display_name' => 'Roles Edit',
                'description' => 'Roles Edit',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-delete',
                'display_name' => 'Roles Delete',
                'description' => 'Roles Delete',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-export',
                'display_name' => 'Roles Export',
                'description' => 'Roles Export',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-show',
                'display_name' => 'Roles Show',
                'description' => 'Roles Show',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-read',
                'display_name' => 'Roles Read',
                'description' => 'Roles Read',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-restore',
                'display_name' => 'Roles Restore',
                'description' => 'Roles Restore',
                'type' => 'Roles'
            ],
            [
                'name' => 'roles-restorAll',
                'display_name' => 'Roles RestorAll',
                'description' => 'Roles RestorAll',
                'type' => 'Roles'
            ],

            /////////////////////////// Leads Permissions //////////////////////////////////////////
            [
                'name' => 'leads-create',
                'display_name' => 'Create Leads',
                'description' => 'Create Leads',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-read',
                'display_name' => 'Leads Read',
                'description' => 'Leads Read',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-show',
                'display_name' => 'Leads Show',
                'description' => 'Leads Show',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-blocklist',
                'display_name' => 'Leads Blocklist',
                'description' => 'Leads Blocklist',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-assignUsers',
                'display_name' => 'Leads AssignUsers',
                'description' => 'Leads AssignUsers',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-changeStatus',
                'display_name' => 'Leads ChangeStatus',
                'description' => 'Leads ChangeStatus',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-delayLeads',
                'display_name' => 'Leads DelayLeads',
                'description' => 'Leads DelayLeads',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-delaytime',
                'display_name' => 'Leads DelayTime',
                'description' => 'Manage delay time of leads',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-edit',
                'display_name' => 'Leads Edit',
                'description' => 'Leads Edit',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-delete',
                'display_name' => 'Leads Block',
                'description' => 'Leads Block',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-createStatus',
                'display_name' => 'Leads CreateStatus',
                'description' => 'Leads CreateStatus',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-phoneNumbers',
                'display_name' => 'Leads PhoneNumbers',
                'description' => 'Leads PhoneNumbers',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-create-PhoneNumber',
                'display_name' => 'Leads Create-PhoneNumber',
                'description' => 'Leads Create-PhoneNumber',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-edit-phoneNumber',
                'display_name' => 'Leads Edit-phoneNumber',
                'description' => 'Leads Edit-phoneNumber',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-delete-phoneNumber',
                'display_name' => 'Leads Delete-phoneNumber',
                'description' => 'Leads Delete-phoneNumber',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-clientProfile',
                'display_name' => 'Leads ClientProfile',
                'description' => 'Leads ClientProfile',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-nextAction',
                'display_name' => 'Leads NextAction',
                'description' => 'Leads NextAction',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-actionHistory',
                'display_name' => 'Leads ActionHistory',
                'description' => 'Leads ActionHistory',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-makeCall',
                'display_name' => 'Leads MakeCall',
                'description' => 'Leads MakeCall',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-archive',
                'display_name' => 'Leads Archive',
                'description' => 'Leads Archive',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-restore',
                'display_name' => 'Leads Restore',
                'description' => 'Leads Restore',
                'type' => 'Leads'
            ],
            [
                'name' => 'leads-restorAll',
                'display_name' => 'Leads RestorAll',
                'description' => 'Leads RestorAll',
                'type' => 'Leads'
            ],
            /////////////////////////// communications Permissions //////////////////////////////////////////
            [
                'name' => 'communications-show',
                'display_name' => 'communications Show',
                'description' => 'communications Show',
                'type' => 'Communications'
            ],
            [
                'name' => 'communications-read',
                'display_name' => 'communications Read',
                'description' => 'communications Read',
                'type' => 'Communications'
            ],
            [
                'name' => 'communications-excel',
                'display_name' => 'communications Excel',
                'description' => 'communications Excel',
                'type' => 'Communications'
            ],

            /////////////////////////// clients Permissions //////////////////////////////////////////
            [
                'name' => 'clients.show',
                'display_name' => 'Clients Show',
                'description' => 'Clients Show',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-delete',
                'display_name' => 'Clients Delete',
                'description' => 'Clients Delete',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-read',
                'display_name' => 'Clients Read',
                'description' => 'Clients Read',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-upload',
                'display_name' => 'Clients Upload',
                'description' => 'Clients Upload',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-archive',
                'display_name' => 'Clients Archive',
                'description' => 'Clients Archive',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-export',
                'display_name' => 'Clients Export',
                'description' => 'Clients Export',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-edit',
                'display_name' => 'Clients Edit',
                'description' => 'Clients Edit',
                'type' => 'Clients'
            ],
            [
                'name' => 'delete-permanently',
                'display_name' => 'Clients delete permanently',
                'description' => 'Clients delete permanently',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-uploadImages',
                'display_name' => 'Clients UploadImages',
                'description' => 'Clients UploadImages',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-uploadFiles',
                'display_name' => 'Clients UploadFiles',
                'description' => 'Clients UploadFiles',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-toLead',
                'display_name' => 'Clients ToLead',
                'description' => 'Clients ToLead',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-makeReservation',
                'display_name' => 'Clients MakeReservation',
                'description' => 'Clients MakeReservation',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-phoneNumbers',
                'display_name' => 'Clients PhoneNumbers',
                'description' => 'Clients PhoneNumbers',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-create-PhoneNumber',
                'display_name' => 'Clients Create-PhoneNumber',
                'description' => 'Clients Create-PhoneNumber',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-edit-phoneNumber',
                'display_name' => 'Clients Edit-phoneNumber',
                'description' => 'Clients Edit-phoneNumber',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-delete-phoneNumber',
                'display_name' => 'Clients Delete-phoneNumber',
                'description' => 'Clients Delete-phoneNumber',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-units',
                'display_name' => 'Clients Units',
                'description' => 'Clients Units',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-paymentPlan',
                'display_name' => 'Clients PaymentPlan',
                'description' => 'Clients PaymentPlan',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-tickets',
                'display_name' => 'Clients Tickets',
                'description' => 'Clients Tickets',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-showTicket',
                'display_name' => 'Clients ShowTicket',
                'description' => 'Clients ShowTicket',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-gallery',
                'display_name' => 'Clients Gallery',
                'description' => 'Clients Gallery',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-files',
                'display_name' => 'Clients Files',
                'description' => 'Clients Files',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-restore',
                'display_name' => 'Clients Restore',
                'description' => 'Clients Restore',
                'type' => 'Clients'
            ],
            [
                'name' => 'clients-restorAll',
                'display_name' => 'Clients RestorAll',
                'description' => 'Clients RestorAll',
                'type' => 'Clients'
            ],

            /////////////////////////// Contracts Permissions //////////////////////////////////////////
            [
                'name' => 'contracts-show',
                'display_name' => 'Contracts Show',
                'description' => 'Contracts Show',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-read',
                'display_name' => 'Contracts Read',
                'description' => 'Contracts Read',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-codes',
                'display_name' => 'Contracts Codes',
                'description' => 'Contracts Codes',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-clientContracts',
                'display_name' => 'Contracts ClientContracts',
                'description' => 'Contracts ClientContracts',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-create',
                'display_name' => 'Contracts Create',
                'description' => 'Contracts Create',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-print',
                'display_name' => 'Contracts Print',
                'description' => 'Contracts Print',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-delete',
                'display_name' => 'Contracts Delete',
                'description' => 'Contracts Delete',
                'type' => 'Contracts'
            ],
            [
                'name' => 'contracts-edit',
                'display_name' => 'Contracts Edit',
                'description' => 'Contracts Edit',
                'type' => 'Contracts'
            ],

            /////////////////////////// Campaigns Permissions //////////////////////////////////////////
            [
                'name' => 'campaigns-create',
                'display_name' => 'Campaigns Create',
                'description' => 'Campaigns Create',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-edit',
                'display_name' => 'Campaigns Edit',
                'description' => 'Campaigns Edit',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-read',
                'display_name' => 'Campaigns Read',
                'description' => 'Campaigns Read',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-show',
                'display_name' => 'Campaigns Show',
                'description' => 'Campaigns Show',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-delete',
                'display_name' => 'Campaigns Delete',
                'description' => 'Campaigns Delete',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-restore',
                'display_name' => 'Campaigns Restore',
                'description' => 'Campaigns Restore',
                'type' => 'Campaigns'
            ],
            [
                'name' => 'campaigns-restorAll',
                'display_name' => 'Campaigns RestorAll',
                'description' => 'Campaigns RestorAll',
                'type' => 'Campaigns'
            ],

            /////////////////////////// Sources Permissions //////////////////////////////////////////
            [
                'name' => 'sources-create',
                'display_name' => 'Sources Create',
                'description' => 'Sources Create',
                'type' => 'Sources'
            ],
            [
                'name' => 'sources-edit',
                'display_name' => 'Sources Edit',
                'description' => 'Sources Edit',
                'type' => 'Sources'
            ],
            [
                'name' => 'sources-show',
                'display_name' => 'Sources Show',
                'description' => 'Sources Show',
                'type' => 'Sources'
            ],
            [
                'name' => 'sources-read',
                'display_name' => 'Sources Read',
                'description' => 'Sources Read',
                'type' => 'Sources'
            ],

            /////////////////////////// Projects Permissions //////////////////////////////////////////
            [
                'name' => 'projects-create',
                'display_name' => 'Projects Create',
                'description' => 'Projects Create',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-edit',
                'display_name' => 'Projects Edit',
                'description' => 'Projects Edit',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-show',
                'display_name' => 'Projects Show',
                'description' => 'Projects Show',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-read',
                'display_name' => 'Projects Read',
                'description' => 'Projects Read',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-delete',
                'display_name' => 'Projects Delete',
                'description' => 'Projects Delete',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-archive',
                'display_name' => 'Projects Archive',
                'description' => 'Projects Archive',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-uploadFiles',
                'display_name' => 'Projects UploadFiles',
                'description' => 'Projects UploadFiles',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-uploadImages',
                'display_name' => 'Projects UploadImages',
                'description' => 'Projects UploadImages',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-hide',
                'display_name' => 'Projects Hide',
                'description' => 'Projects Hide',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-facilities',
                'display_name' => 'Projects Facilities',
                'description' => 'Projects Facilities',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-paymentPlan',
                'display_name' => 'Projects PaymentPlan',
                'description' => 'Projects PaymentPlan',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-accessedUsers',
                'display_name' => 'Projects AccessedUsers',
                'description' => 'Projects AccessedUsers',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-campaigns',
                'display_name' => 'Projects Campaigns',
                'description' => 'Projects Campaigns',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-files',
                'display_name' => 'Projects Files',
                'description' => 'Projects Files',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-gallery',
                'display_name' => 'Projects Gallery',
                'description' => 'Projects Gallery',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-paymentPlans-create',
                'display_name' => 'Projects PaymentPlans-Create',
                'description' => 'Projects PaymentPlans-Create',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-restore',
                'display_name' => 'Projects Restore',
                'description' => 'Projects Restore',
                'type' => 'Projects'
            ],
            [
                'name' => 'projects-restorAll',
                'display_name' => 'Projects RestorAll',
                'description' => 'Projects RestorAll',
                'type' => 'Projects'
            ],
            /////////////////////////// Phases Permissions //////////////////////////////////////////
            [
                'name' => 'phases-archive',
                'display_name' => 'Phases Archive',
                'description' => 'Phases Archive',
                'type' => 'Phases'
            ],
            [
                'name' => 'phases-hide',
                'display_name' => 'Phases Hide',
                'description' => 'Phases Hide',
                'type' => 'Phases'
            ],
            [
                'name' => 'phases-show',
                'display_name' => 'Phases Show',
                'description' => 'Phases Show',
                'type' => 'Phases'
            ],
            [
                'name' => 'phases-create',
                'display_name' => 'Phases create',
                'description' => 'Phases create',
                'type' => 'Phases'
            ],
            [
                'name' => 'phases-read',
                'display_name' => 'Phases Read',
                'description' => 'Phases Read',
                'type' => 'Phases'
            ],
            [
                'name' => 'phases-edit',
                'display_name' => 'Phases Edit',
                'description' => 'Phases Edit',
                'type' => 'Phases'
            ],

            /////////////////////////// buildings Permissions //////////////////////////////////////////
            [
                'name' => 'buildings-create',
                'display_name' => 'Buildings Create',
                'description' => 'Buildings Create',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-show',
                'display_name' => 'Buildings show',
                'description' => 'Buildings show',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-hide',
                'display_name' => 'Buildings Hide',
                'description' => 'Buildings Hide',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-edit',
                'display_name' => 'Buildings edit',
                'description' => 'Buildings edit',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-delete',
                'display_name' => 'Buildings delete',
                'description' => 'Buildings delete',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-read',
                'display_name' => 'Buildings Read',
                'description' => 'Buildings Read',
                'type' => 'Buildings'
            ],
            [
                'name' => 'buildings-archive',
                'display_name' => 'Buildings Archive',
                'description' => 'Buildings Archive',
                'type' => 'Buildings'
            ],

            /////////////////////////// Units Permissions //////////////////////////////////////////
            [
                'name' => 'units-upload',
                'display_name' => 'Units Upload',
                'description' => 'Units Upload',
                'type' => 'Units'
            ],
            [
                'name' => 'units-show',
                'display_name' => 'Units show',
                'description' => 'Units show',
                'type' => 'Units'
            ],
            [
                'name' => 'units-hide',
                'display_name' => 'Units Hide',
                'description' => 'Units Hide',
                'type' => 'Units'
            ],
            [
                'name' => 'units-edit',
                'display_name' => 'Units edit',
                'description' => 'Units edit',
                'type' => 'Units'
            ],
            [
                'name' => 'units-delete',
                'display_name' => 'Units delete',
                'description' => 'Units delete',
                'type' => 'Units'
            ],
            [
                'name' => 'units-archive',
                'display_name' => 'Units Archive',
                'description' => 'Units Archive',
                'type' => 'Units'
            ],
            [
                'name' => 'units-history',
                'display_name' => 'Units History',
                'description' => 'Units History',
                'type' => 'Units'
            ],
            [
                'name' => 'units-uploadFiles',
                'display_name' => 'Units UploadFiles',
                'description' => 'Units UploadFiles',
                'type' => 'Units'
            ],
            [
                'name' => 'units-uplaodImages',
                'display_name' => 'Units UplaodImages',
                'description' => 'Units UplaodImages',
                'type' => 'Units'
            ],
            [
                'name' => 'units-createContract',
                'display_name' => 'Units CreateContract',
                'description' => 'Units CreateContract',
                'type' => 'Units'
            ],
            [
                'name' => 'units-DeliveryDate',
                'display_name' => 'Units DeliveryDate',
                'description' => 'Units DeliveryDate',
                'type' => 'Units'
            ],
            [
                'name' => 'units-paymentPlan',
                'display_name' => 'Units PaymentPlan',
                'description' => 'Units PaymentPlan',
                'type' => 'Units'
            ],
            [
                'name' => 'units-contracts',
                'display_name' => 'Units Contracts',
                'description' => 'Units Contracts',
                'type' => 'Units'
            ],
            [
                'name' => 'units-files',
                'display_name' => 'Units Files',
                'description' => 'Units Files',
                'type' => 'Units'
            ],
            [
                'name' => 'units-gallery',
                'display_name' => 'Units Gallery',
                'description' => 'Units Gallery',
                'type' => 'Units'
            ],
            [
                'name' => 'units-read',
                'display_name' => 'Units Read',
                'description' => 'Units Read',
                'type' => 'Units'
            ],
            [
                'name' => 'units-restore',
                'display_name' => 'Units Restore',
                'description' => 'Units Restore',
                'type' => 'Units'
            ],
            [
                'name' => 'units-restorAll',
                'display_name' => 'Units RestorAll',
                'description' => 'Units RestorAll',
                'type' => 'Units'
            ],

            /////////////////////////// Tickets Permissions //////////////////////////////////////////
            [
                'name' => 'tickets-create',
                'display_name' => 'Tickets Create',
                'description' => 'Tickets Create',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-show',
                'display_name' => 'Tickets Show',
                'description' => 'Tickets Show',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-read',
                'display_name' => 'Tickets Read',
                'description' => 'Tickets Read',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-delayTickets-read',
                'display_name' => 'Tickets DelayTickets-Read',
                'description' => 'Tickets DelayTickets-Read',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-ticketActions-read',
                'display_name' => 'Tickets TicketActions-Read',
                'description' => 'Tickets TicketActions-Read',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-ticketTypes-read',
                'display_name' => 'Tickets TicketTypes-Read',
                'description' => 'Tickets TicketTypes-Read',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-assignUser',
                'display_name' => 'Tickets AssignUser',
                'description' => 'Tickets AssignUser',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-changeStatus',
                'display_name' => 'Tickets changeStatus',
                'description' => 'Tickets changeStatus',
                'type' => 'Tickets'
            ],
            [
                'name' => 'tickets-createComment',
                'display_name' => 'Tickets createComment',
                'description' => 'Tickets createComment',
                'type' => 'Tickets'
            ],

            /////////////////////////// Brokers Permissions //////////////////////////////////////////
            [
                'name' => 'brokers-create',
                'display_name' => 'Brokers Create',
                'description' => 'Brokers Create',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-edit',
                'display_name' => 'Brokers Edit',
                'description' => 'Brokers Edit',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-show',
                'display_name' => 'Brokers Show',
                'description' => 'Brokers Show',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-read',
                'display_name' => 'Brokers Read',
                'description' => 'Brokers Read',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-import',
                'display_name' => 'Brokers Import',
                'description' => 'Brokers Import',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-archive',
                'display_name' => 'Brokers Archive',
                'description' => 'Brokers Archive',
                'type' => 'Brokers'
            ],
            [
                'name' => 'broker-restore',
                'display_name' => 'Broker Restore',
                'description' => 'Broker Restore',
                'type' => 'Brokers'
            ],
            [
                'name' => 'brokers-restorAll',
                'display_name' => 'Broker RestorAll',
                'description' => 'Broker RestorAll',
                'type' => 'Brokers'
            ],

            /////////////////////////// Cil Permissions //////////////////////////////////////////

            [
                'name' => 'cil-read',
                'display_name' => 'Cil Read',
                'description' => 'Cil Read',
                'type' => 'Cil'
            ],

            [
                'name' => 'cil-confirm',
                'display_name' => 'Cil Read',
                'description' => 'Cil Read',
                'type' => 'Cil'
            ],

            /////////////////////////// Generals Permissions //////////////////////////////////////////
            [
                'name' => 'permission-read',
                'display_name' => 'Permissions Read',
                'description' => 'Permissions Read',
                'type' => 'Generals'
            ],
            [
                'name' => 'sourcesTypes-create',
                'display_name' => 'sourcesTypes Create',
                'description' => 'sourcesTypes Create',
                'type' => 'Generals'
            ],
            [
                'name' => 'facilities-create',
                'display_name' => 'Facilities Create',
                'description' => 'Facilities Create',
                'type' => 'Generals'
            ],
            [
                'name' => 'unitSettings-create',
                'display_name' => 'UnitSettings Create',
                'description' => 'UnitSettings Create',
                'type' => 'Generals'
            ],
            [
                'name' => 'settings-create',
                'display_name' => 'Settings Create',
                'description' => 'Settings Create',
                'type' => 'Generals'
            ],
            [
                'name' => 'activityLog-read',
                'display_name' => 'ActivityLog Read',
                'description' => 'ActivityLog Read',
                'type' => 'Generals'
            ],

            //////////////////////////////////// new permission ///////////////////////////////////
            [
                'name' => 'users-delete',
                'display_name' => 'User Delete',
                'description' => 'User Delete',
                'type' => 'Users'
            ],
            [
                'name' => 'communications-nextAction',
                'display_name' => 'communication nextAction',
                'description' => 'Communication nextAction',
                'type' => 'Communications'
            ],
        ];
        foreach ($permessions as $key => $value) {
            Permission::create($value);
        }
    }
}
