<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('brokers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('description')->nullable();
            $table->string('email')->nullable();
            $table->string('type')->nullable();
            $table->string('address')->nullable();
            $table->string('owner_name')->nullable();
            $table->string('commercial_record')->nullable();
            $table->string('authorized_name')->nullable();
            $table->string('sales_admin')->nullable();
            $table->boolean('has_contract')->nullable();
            $table->string('contract_startDate')->nullable();
            $table->string('contract_endDate')->nullable();
            $table->string('commission')->nullable();

            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users');
            
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('brokers');
    }
};
