<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('unit_details', function (Blueprint $table) {

            $table->unsignedInteger('unit_setting_id');

            $table->unsignedInteger('unit_id');

            $table->foreign('unit_setting_id')->references('id')->on('unit_settings')->onDelete('cascade');

            $table->foreign('unit_id')->references('id')->on('units')->onDelete('cascade');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('unit_details');
    }
};
