<?php

return [
    /**
     * Control if the seeder should create a user per role while seeding the data.
     */
    'create_users' => false,

    /**
     * Control if all the laratrust tables should be truncated before running the seeder.
     */
    'truncate_tables' => true,

    'roles_structure' => [
        'SuperAdmin' => [
            'users' => 'c,r,u,d',
            'profile' => 'r,u',
            'roles' => 'c,r,u,d',
            'permissions' => 'r,d',
            'leads' => 'c,r,u,d,e,i',
            'offers' => 'c,r,u,d',
            'clients' => 'c,r,u,d',
            'communications' => 'c,r', 
            'campaigns' => 'c,r,u,d',
            'projects' => 'c,r,u,d',
            'phases' => 'c,r,u,d',
            'buildings' => 'c,r,u,d',
            'units' => 'c,r,u,d',
            'settings' => 'r',
            'tickets' => 'c,r,d'
        ],
        'Sales' => [
            'leads' => 'r,u',
            'offers' => 'c,r,u,d',
            'clients' => 'c,r,u,d',
        ]
    ],

    'permissions_map' => [
        'c' => 'create',
        'r' => 'read',
        'u' => 'update',
        'd' => 'delete',
        'e' => 'export',
        'i' => 'import',
    ]
];
