<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class UnitSetting extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;

    public $guarded = [];
    protected $table = 'unit_settings';

    public function unitType()
    {
        return $this->hasMany(Unit::class, 'type');
    }

    public function unitView()
    {
        return $this->hasMany(Unit::class, 'view');
    }
    
    public function unitFinishing()
    {
        return $this->hasMany(Unit::class, 'finishing');
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Unit Action');;
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }
}
