<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Category extends Model implements HasMedia
{
    use HasFactory,HasTranslations;
    use InteractsWithMedia;
    
    public $translatable = ['name'];
    
    public function getImageAttribute($value)
    {
        $file = $this->getMedia('image')->last();
        if ($file) {
            $file->url       = $file->getUrl();
            // $file->thumbnail = $file->getUrl('thumb');
        }
        return $file;
    }
}
