<?php

namespace App\Imports;

use App\Models\Unit;
use App\Models\Phase;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Client;
use App\Models\Building;
use App\Models\ClientContract;
use App\Models\UnitSetting;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
// use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class UnitsUpdateImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows
{
    use Importable;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $unit = Unit::find($row['unit_id']);
        if($row['contract_date'] != NULL){

            // Update Contarct Date in table client_contract
            $contract_type = gettype($row['contract_date']);
            if($contract_type == "integer"){
                $contract_date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['contract_date']);
                
            }else{
                $contract_date = $row['contract_date'];
            }
            
            $clientContract = ClientContract::where(['unit_id'=> $row['unit_id'] , 'client_id' => $row['client_id']])->first();
            
            if($clientContract != NULL){
                $clientContract->contract_date = $contract_date->format('Y-m-d');
                $clientContract->save();
            }
            
        }
        
        if($row['delivery_date'] != NULL){

            // Update Contarct Date in table client_contract
            $contract_type = gettype($row['delivery_date']);
            if($contract_type == "integer"){
                $delivery_date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['delivery_date']);
                
            }else{
                $delivery_date = $row['delivery_date'];
            }
            
            $delivery_row = Payment::where(['unit_id'=> $row['unit_id'] , 'client_id' => $row['client_id']])->first();
            
            if($delivery_row != NULL){
                $delivery_row->delivery_date = $delivery_date->format('Y-m-d');
                $delivery_row->save();
            }
            
        }
        return $unit;
    }
        
    

    public function rules(): array
    {
        return [
            'unit_id' => ['required'],
            'client_id' =>['required'],
            'delivery_date' =>['nullable'],
            'contract_date' =>['nullable'],
        ];
    }
}
