<?php

namespace App\Imports;

use App\Models\Unit;
use App\Models\Phase;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Client;
use App\Models\Building;
use App\Models\ClientContract;
use App\Models\UnitSetting;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
// use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class UnitsImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows
{
    use Importable;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        
            $contract_type = gettype($row['contract_date']);
            $contract_date='';
            if(!empty($row['contract_date']) && $contract_type == "integer"){
            $contract_date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['contract_date']);
            }else{
                $contract_date = $row['contract_date'];
            }

        $units = DB::table('units')->select('id')->where(['name' => $row['name'], 'project_id' => $row['project_id']])->get();
        if(count($units) != 0){
        }else{
            $unit =  new Unit();
            
            if($row['unit_total_price'] == 0){
                $unit_price = $row['unit_meter_price'] * $row['unit_space'];
                $garden_meter_price =  $row['unit_meter_price'] / 3;
                $garden_price = $garden_meter_price * $row['garden_space'];
    
                $roof_meter_price =  $row['unit_meter_price'] / 3;
                $roof_price = $roof_meter_price * $row['roof_space'];
    
                $unit_total_price = $unit_price + $garden_price + $roof_price;
            }else{
                
                $unit_total_price = $row['unit_total_price'];
            }
    
            if($row['client_id'] != null){
                $client = Client::find($row['client_id']);
                if(isset($client)){
                    $unit->client_id = $client->id;
                    $unit->status = $row['status'];
                    $unit->source_id = $row['source_id'] ?? Null;
                }else{
                    $unit->client_id = NULL;
                }
            }else{
                $unit->client_id = NULL;
                $unit->status = $row['status'] ?? 'free';
            } 

            $unit->name = $row['name'];
            $unit->project_id = $row['project_id'];
            $unit->building_id = $row['building_id'];
            $unit->unit_space = $row['unit_space'];
                        
            $unit->unit_total_price = $unit_total_price;
    
            $unit->roof_total_price = $row['unit_total_price'] == 0 ? $roof_price : $row['roof_total_price'];
            $unit->garden_total_price = $row['unit_total_price'] == 0 ? $garden_price : $row['garden_total_price'];
            $unit->unit_meter_price = $row['unit_meter_price'];
            
            $unit->floor = $row['floor'];
            $unit->garden_space = $row['garden_space'];
            $unit->roof_space = $row['roof_space'];
            $unit->type = $row['type'] ?? '';
            $unit->finishing = $row['finishing'] ?? '';
            $unit->view = $row['view'] ?? '';
                // dd($client);
    
            $unit->bedrooms = $row['bedrooms'] ?? 0;
            $unit->bathrooms = $row['bathrooms'] ?? 0;
            $unit->dressing = $row['dressing'] ?? 0;
            $unit->description = $row['description'] ?? '';
            $unit->is_active = $row['is_active'] ?? 1; // hidden or not
    
            $unit->save();
            
            if($row['client_id'] != null){
                $client = Client::find($row['client_id']);
                if(isset($client)){
                    $payment = new Payment();
                    $payment->client_id = $client->id;
                    $payment->unit_id = $unit->id;
                    $payment->save();
    
                    $contract = new ClientContract();
                    $contract->client_id = $client->id;
                    $contract->unit_id = $unit->id;
                    $contract->contract_date = $contract_date ?? '';
                    $contract->is_delivered = $row['is_delivered'] ?? 0;
                    $contract->save();
                }else{
                    $unit->client_id = NULL;
                }
            }else{
                $unit->client_id = NULL;
            } 
    
            return $unit;
        }
        
    }

    public function rules(): array
    {
        return [
            'name' => ['required'],
            'building_id' => ['required'],

            'unit_total_price' => ['required'],

            'unit_meter_price' => ['required'],
            'unit_space' => ['required'],

            'roof_total_price' => ['required'],
            'roof_space' => ['required'],

            'garden_total_price' => ['required'],
            'garden_space' => ['required'],

            'floor' => ['required'],
            'type' => ['required'],
            'finishing' => ['required'],
            'view' => ['required'],
        ];
    }
}
