<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Source;
use App\Models\Campaign;
use App\Exports\SearchResultExport;

use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;

use Doctrine\DBAL\Schema\Schema as SchemaSchema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Arr;
use Maatwebsite\Excel\Facades\Excel;


class ClientSourceImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows,SkipsOnFailure
{
    use Importable,SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        //$assignedUser = User::whereName($row['assigned_user'])->first();

        $name = rtrim($row['name']);
        $client = DB::table('clients')->select('name', 'id')->where('name', $name)->first();

        $data = array();
        if(isset($client)){
            array_push($data, $client);
        }

        return Excel::download(new SearchResultExport($data), 'SearchResultExport.xlsx');
    }

    public function rules(): array
    {
        return [
            'name' => ['required'],
        ];
    }
    
     public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        $data = [];
        foreach ($failures as $failure) {

            array_push($data,$failure->errors());
        }

        Session::push('leadsErrors', collect($data));
    }
}
