<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\User;
use App\Models\Country;
use App\Models\PhoneNumber;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;

class ClientImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows,SkipsOnFailure
{
    use Importable,SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        //$assignedUser = User::whereName($row['assigned_user'])->first();

        $client = new Client([
            'name' => $row['name'],
            'email' => $row['email'],
            'job_title' => $row['job_title'],
            'came_from' => $row['came_from'],
            'civil_date' => $row['civil_date'],
            'civil_city' => $row['civil_city'],
            'civil_number' => $row['civil_number'],
            'civil_address' => $row['civil_address'],
            'nationality' => $row['nationality'],
            'user_id' => $row['user_id'],
        ]);
        $client->save();
        $country = Country::Where('phonecode',$row['country_code'])->first();

        $phone = PhoneNumber::create([
            'phone' => $row['mobile_number'],
            'client_id' => $client->id,
            'country_id' => $country->id,
        ]);
        
         if($row['mobile_number2'] != null){
            $country2 = Country::Where('phonecode',$row['country_code2'])->first();

            $phone2 = PhoneNumber::create([
                'phone' => $row['mobile_number2'],
                'client_id' => $client->id,
                'country_id' => $country2->id,
            ]);
        }

        return $client;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'email' => ['nullable'],
            'country_code' => ['required'],
            'mobile_number' => ['required','unique:phone_numbers,phone'],
            'job_title' => ['nullable'],
            'came_from' => ['nullable'],
            'civil_date' =>['nullable'],
            'civil_city' =>['nullable'],
            'civil_number' =>['nullable', 'unique:clients,civil_number'],
            'civil_address' =>['nullable'],
            'nationality' =>['nullable'],
            'user_id' =>['nullable'],
        ];
    }
    
     public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        $data = [];
        foreach ($failures as $failure) {

            array_push($data,$failure->errors());
        }

        Session::push('leadsErrors', collect($data));
    }

    public function customValidationMessages()
    {
        return [
            'mobile_number.unique' => 'This mobile number :input is duplicated.',
            'mobile_number2.unique' => 'This mobile number :input is duplicated.',
            'civil_number.unique' => 'This civil number :input is duplicated.',
        ];
    }
}
