<?php

namespace App\Http\Requests\API\Auth\Guest;

use Illuminate\Foundation\Http\FormRequest;

class GuestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|min:3',
            'email' => 'required|email|unique:leads',
            'address' => 'required',
            'mobile_number' => 'required|unique:leads',
            'age' => 'required',
            'job_title' => 'required',
            'social_status' => 'required|in:0,1',
            'familly_number'=>'required_if:social_status,==,1'
        ];
    }
}
