<?php

namespace App\Http\Controllers;

use App\Models\TicketType;
use Illuminate\Http\Request;

class TicketTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $ticketTypes = TicketType::get();
        return view('ticketTypes.create', compact('ticketTypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $ticketTypes = TicketType::pluck('name');
    
        $fCount = count($ticketTypes);
        $rCount = count($request->name);

        if($rCount >= $fCount){
            for ($i=0; $i<$rCount; $i++) {
                TicketType::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                    [
                        'hours' => $request->hours[$i]
                    ]
                );
            }
        }
        // else{
        //     for($s=0; $s < $fCount; $s++){
                
        //             $TicketType = TicketType::where('name', $ticketTypes[$s])->first();
        //             $TicketType->delete();
                
        //         }
        // }

         $user = auth()->user();
         activity()
         ->event('update')
         ->log($user->name .' updated Ticket Types');
        return redirect()->back()->with('success', 'Ticket Types updated Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TicketType  $ticketType
     * @return \Illuminate\Http\Response
     */
    public function show(TicketType $ticketType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TicketType  $ticketType
     * @return \Illuminate\Http\Response
     */
    public function edit(TicketType $ticketType)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TicketType  $ticketType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TicketType $ticketType)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TicketType  $ticketType
     * @return \Illuminate\Http\Response
     */
    public function destroy(TicketType $ticketType)
    {
        //
        $ticketType->delete();
        return redirect()->back()->with('success', 'Ticket Types Trashed Successfully');

    }
}
