<?php

namespace App\Http\Controllers;

use App\Models\SourceType;
use Illuminate\Http\Request;

class SourceTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() 
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $sourceTypes = SourceType::get();
        return view('sourceTypes.create', compact('sourceTypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $sourceTypes = SourceType::pluck('name');
    
        $fCount = count($sourceTypes);
        $rCount = count($request->name);

        if($rCount >= $fCount){
            for ($i=0; $i<$rCount; $i++) {
                SourceType::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                );
            }
        }

        $user = auth()->user();
         activity()
         ->event('update')
         ->log($user->name .' updated Source Types');
        return redirect()->back()->with('success', 'Source Types updated Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SourceType  $sourceType
     * @return \Illuminate\Http\Response
     */
    public function show(SourceType $sourceType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SourceType  $sourceType
     * @return \Illuminate\Http\Response
     */
    public function edit(SourceType $sourceType)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SourceType  $sourceType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SourceType $sourceType)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SourceType  $sourceType
     * @return \Illuminate\Http\Response
     */
    public function destroy(SourceType $sourceType)
    {
        //
        $sourceType->delete();
        return redirect()->back()->with('success', 'Source Types Trashed Successfully');
    }
}
