<?php

namespace App\Http\Controllers;

use App\Models\Source;
use App\Models\Project;
use App\Models\SourceType;
use App\Models\Campaign;
use App\Exports\SourcesExport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class SourceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $allSources = Source::get();
        $sources = Source::paginate(100)->withQueryString();
        return view('sources.index', compact('sources', 'allSources'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $projects = Project::get();
        $campaigns = Campaign::get();
        $sourceTypes = SourceType::get();

        return view('sources.create', compact('projects', 'campaigns', 'sourceTypes'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $source = new Source();
        $source->name = $request->name;
        $source->project_id = $request->project_id;
        $source->sourceType_id = $request->sourceType_id;
        $source->campaign_id = $request->campaign_id;
        $source->save();

        return redirect()->route('sources.index')->with('success', 'Source created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Source  $source
     * @return \Illuminate\Http\Response
     */
    public function show(Source $source)
    {
        //
        // dd($source->sourceType);
        return view('sources.show', compact('source'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Source  $source
     * @return \Illuminate\Http\Response
     */
    public function edit(Source $source)
    {
        //

        $projects = Project::get();
        $campaigns = Campaign::get();
        $sourceTypes = SourceType::get();

        return view('sources.edit', compact('projects', 'campaigns', 'sourceTypes', 'source'));    
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Source  $source
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Source $source)
    {
        //
        $source->name = $request->name;
        $source->project_id = $request->project_id;
        $source->sourceType_id = $request->sourceType_id;
        $source->campaign_id = $request->campaign_id;
        $source->save();

        return redirect()->route('sources.show', $source->id)->with('success', 'Source Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Source  $source
     * @return \Illuminate\Http\Response
     */
    public function destroy(Source $source)
    {
        //
        $source->delete();
        return redirect()->route('sources.index')->with('success', 'Source deleted Successfully');

    }

    /**
     * Export sources to Excel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function export(Request $request)
    {
        $user = auth()->user();
        activity()
            ->event('export')
            ->log($user->name . ' exported sources data');

        return Excel::download(new SourcesExport($request), 'sources_' . date('Y-m-d_H-i-s') . '.xlsx');
    }
}
