<?php

namespace App\Http\Controllers;

use App\Exports\CilReportExport;
use App\Exports\DailyCrmReportExport;
use App\Exports\dailyProjectsReportExport;
use App\Exports\DailySalesReport;
use App\Exports\ReportsExport;
use App\Exports\UsersExport;
use App\Models\Lead;
use App\Models\User;
use App\Models\LeadUser;
use App\Models\Campaign;
use App\Models\Project;
use App\Models\Unit;
use App\Models\Client;
use App\Models\ClientContract;
use App\Models\Communication;
use App\Models\Facility;
use App\Models\FacilityUnit;
use App\Models\Payment;
use App\Models\PhoneNumber;
use App\Models\Status;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Doctrine\DBAL\Schema\Schema as SchemaSchema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Arr;
use Maatwebsite\Excel\Facades\Excel;

class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }


    public function userLeads()
    {
        $leadUsers = LeadUser::get();
        $reports[] = '';

        foreach ($leadUsers as $leadUser) {
            // User 
            $user = User::find($leadUser->user_id);
            $lead = Lead::find($leadUser->lead_id);


            if ($user->id == Null) {
                $user = User::withTrashed()->where('id', $leadUser->user_id)->first();
                $userId = $user->id;
                $userName = $user->name;
            } else {
                $userId = $user->id;
                $userName = $user->name;
            }

            // Lead
            if (!isset($lead)) {
                $lead = Lead::withTrashed()->where('id', $leadUser->lead_id)->first();
                $leadId = $lead->id;
                $leadName = $lead->name;
                $leadStatus = $lead->status;
            } else {
                $leadId = $lead->id;
                $leadName = $lead->name;
                $leadStatus = $lead->status;
            }

            $createdAt = $leadUser->created_at;


            array_push($reports, [
                'userId' => $userId,
                'userName' => $userName,
                'leadId' => $leadId,
                'leadName' => $leadName,
                'leadStatus' => $leadStatus,
                'date' => $createdAt
            ]);
        }
        return view('reports.userLeads', compact('reports'));
    }

    public function ProjectCampagins()
    {
        $projects = Project::get();
        $reports[] = '';

        if (!empty($projects)) {
            foreach ($projects as $project) {
                // $TotalCampaigns = count($project->campaigns);


                foreach ($project->campaigns as $campaign) {

                    $projectId = $project->id;
                    $projectName = $project->name;


                    $campaignId = $campaign->id;
                    $campaignName = $campaign->name;
                    $campaignBudget = $campaign->budget;
                    $start = $campaign->start_date;
                    $end = $campaign->end_date;

                    $leads = Lead::where(['is_client' => 0, 'campaign_id' => $campaign->id])->get();
                    $totalLeads = count($leads);

                    $clients = Lead::where(['is_client' => 1, 'campaign_id' => $campaign->id])->get();
                    $totalClients = count($clients);

                    $new = Lead::where(['status' => 'new', 'campaign_id' => $campaign->id])->get();
                    $TotalNew = count($new);

                    $inProgress = Lead::where(['status' => 'in-process', 'campaign_id' => $campaign->id])->get();
                    $TotalInProgress = count($inProgress);
                    // dd($inProgress);

                    $interested = Lead::where(['status' => 'interestad', 'campaign_id' => $campaign->id])->get();
                    $TotalInterested = count($interested);
                    // dd($interested);
                    $not = Lead::where(['status' => 'not_interested', 'campaign_id' => $campaign->id])->get();
                    $TotalNot = count($not);

                    $wait = Lead::where(['status' => 'wait', 'campaign_id' => $campaign->id])->get();
                    $TotalWait = count($wait);

                    $followUp = Lead::where(['status' => 'follow_up', 'campaign_id' => $campaign->id])->get();
                    $TotalfollowUp = count($followUp);

                    $recycled = Lead::where(['status' => 'recycled', 'campaign_id' => $campaign->id])->get();
                    $TotalRecycled = count($recycled);

                    $dead = Lead::where(['status' => 'dead', 'campaign_id' => $campaign->id])->get();
                    $TotalDead = count($dead);

                    array_push($reports, [
                        'projectId' => $projectId,
                        'projectName' => $projectName,
                        'campaignId' => $campaignId,
                        'campaignName' => $campaignName,
                        'campaignBudget' => $campaignBudget,
                        'start' => $start,
                        'end' => $end,
                        'leads' => $totalLeads,
                        'clients' => $totalClients,
                        'new' => $TotalNew,
                        'inProgress' => $TotalInProgress,
                        'interested' => $TotalInterested,
                        'notInterested' => $TotalNot,
                        'followUp' => $TotalfollowUp,
                        'Recycled' => $TotalRecycled,
                        'Dead' => $TotalDead
                    ]);
                }
            }
            // dd($reports);
        }
        return view('reports.ProjectCampaigns', compact('reports'));
    }

    public function CampaignLeads()
    {

        $campaigns = Campaign::get();
        $reports[] = '';

        foreach ($campaigns as $campaign) {
            foreach ($campaign->leads as $lead) {

                $campaignId = $campaign->id;
                $campaignName = $campaign->name;

                $leadId = $lead->id;
                $leadName = $lead->name;

                $user = User::find($lead->user_id);
                $userName = $user->name;
                $userId = $user->id;

                $status = $lead->status;

                array_push($reports, [
                    'leadId' => $leadId,
                    'leadName' => $leadName,

                    'campaignId' => $campaignId,
                    'campaignName' => $campaignName,

                    'userId' => $userId,
                    'userName' => $userName,

                    'status' => $status,
                ]);
            }
        }
        return view('reports.CampaignLeads', compact('reports'));
    }

    public function userSales()
    {
        $units = Unit::whereNotNull('client_id')->get();
        $reports[] = '';
        foreach ($units as $unit) {
            $unitId = $unit->id;
            $unitName = $unit->name;
            $unitState = $unit->status;
            $unitBookedDate = $unit->Booked_date;

            $client = Client::find($unit->client_id);
            $clientId = $client->id;
            $clientName = $client->name;

            $user = User::find($client->user_id);
            $userId = $user->id;
            $userName = $user->name;

            array_push($reports, [
                'unitId' => $unitId,
                'unitName' => $unitName,
                'unitState' => $unitState,
                'unitBookedDate' => $unitBookedDate,

                'clientId' => $clientId,
                'clientName' => $clientName,

                'userId' => $userId,
                'userName' => $userName,

            ]);
        }
        return view('reports.userSales', compact('reports'));
    }

    public function userActions()
    {
        $communications = Communication::where('status', '!=', 'planned')->get();

        $reports[] = '';

        foreach ($communications as $communication) {
            $action = $communication->events()->latest()->first();
            if ($action != Null) {
                $actionTitle = $action->title;
                $actionDate = Carbon::createFromFormat('Y-m-d H:i:s', $action->updated_at)->format('Y-m-d');
            } else {
                if (isset($communication->lead)) {
                    $lead = Lead::find($communication->lead_id);
                } else {
                    $lead = lead::withTrashed()->where('id', $communication->lead_id)->first();
                }

                $actionTitle = "communicated with " . $lead->name;
                $actionDate = Carbon::createFromFormat('Y-m-d H:i:s', $communication->updated_at)->format('Y-m-d');
            }
            if (isset($communication->user_id)) {
                $user = User::find($communication->user_id);
            } else {
                $user = User::withTrashed()->where('id', $communication->user_id)->first();
            }


            $actionStatus = $communication->status;

            $userId = $user->id;
            $userName = $user->name;


            $leadId = $lead->id;
            $leadName = $lead->name;

            array_push($reports, [
                'leadId' => $leadId,
                'leadName' => $leadName,

                'userId' => $userId,
                'userName' => $userName,

                'actionTitle' => $actionTitle,
                'actionStatus' => $actionStatus,
                'actionDate' => $actionDate,

            ]);
        }
        return view('reports.userActions', compact('reports'));
    }

    public function ProjectIncome()
    {
        $units = Unit::where('status', '!=', 'free')->get();

        $reports[] = '';

        foreach ($units as $unit) {
            $project = $unit->building->phase->project;
            $projectId = $project->id;
            $projectName = $project->name;

            $unitId = $unit->id;
            $unitName = $unit->name;
            $unitStatus = $unit->status;

            $totalAmount = $unit->payments->sum('amount');

            array_push($reports, [
                'projectId' => $projectId,
                'projectName' => $projectName,

                'unitId' => $unitId,
                'unitName' => $unitName,

                'unitStatus' => $unitStatus,
                'totalAmount' => $totalAmount,
            ]);
        }
        return view('reports.ProjectIncome', compact('reports'));
    }

    public function unitsReport(Request $request)
    {
        $unit_space = $request->unit_space;
        $unit_status = $request->unit_status;
        $unit_status_free = 'free';
        $unit_finishing = $request->unit_finishing;

        $project = Project::find($request->project_id);

        $units = Unit::when($project != null)->whereHas('building.phase.project', function ($query) use ($project) {
            $query->where('id', $project->id);
        })->where('is_active', 1)
            ->when($unit_space !== null, function ($query) use ($unit_space) {
                $query->wherein('unit_space', $unit_space);
            })
            ->when($unit_status_free !== null, function ($query) use ($unit_status_free) {
                $query->where('status', '!=', $unit_status_free);
            })
            ->when($unit_status !== null, function ($query) use ($unit_status) {
                $query->wherein('status', $unit_status);
            })
            ->when($unit_finishing !== null, function ($query) use ($unit_finishing) {
                $query->wherein('finishing', $unit_finishing);
            })->get();

        $reports = [];

        foreach ($units as $unit) {
            $clientId = $unit->client_id;
            $phoneNumbers = PhoneNumber::where('client_id', $clientId)->get();
            $phoneData = [];

            $phoneData['Project_Name'] = $project->name;
            $phoneData['Unit_ID'] = $unit->id ?? null;
            $phoneData['Unit_name'] = $unit->name ?? null;
            $phoneData['Unit_floor'] = $unit->floor ?? null;
            $phoneData['Unit_unit_space'] = $unit->unit_space ?? null;
            $phoneData['Unit_unit_meter_price'] = $unit->unit_meter_price ?? null;
            $phoneData['Unit_unit_total_price'] = $unit->unit_total_price ?? null;
            $phoneData['Unit_roof_total_price'] = $unit->roof_total_price ?? null;
            $phoneData['Unit_garden_space'] = $unit->garden_space ?? null;
            $phoneData['Unit_garden_total_price'] = $unit->garden_total_price ?? null;
            $phoneData['Unit_bedrooms'] = $unit->bedrooms ?? null;
            $phoneData['Unit_bathrooms'] = $unit->bathrooms ?? null;
            $phoneData['Unit_Booked_date'] = $unit->Booked_date ?? null;
            $phoneData['Unit_is_active'] = $unit->is_active == 0 ? 'not-active' : 'active';
            $phoneData['Unit_user_name'] = $unit->user->name ?? null;
            $phoneData['Unit_client_name'] = $unit->client->name ?? null;
            $phoneData['Unit_building_name'] = $unit->building->name ?? null;
            $phoneData['Unit_type'] = $unit->typee->name ?? null;
            $phoneData['Unit_finishing'] = $unit->finishingLevel->name ?? null;
            $phoneData['Unit_view'] = $unit->vieww->name ?? null;
            $phoneData['Unit_status'] = $unit->status ?? null;
            $phoneData['Unit_created_at'] =   $unit->created_at ?? null;
            $phoneData['Unit_updated_at'] =  $unit->updated_at ?? null;
            $phoneData['Unit_dressing'] = $unit->dressing ?? null;
            $phoneData['Unit_description'] = $unit->description ?? null;
            $phoneData['Unit_roof_space'] = $unit->roof_space ?? null;
            $phoneData['Client_ID'] = $unit->client->id ?? null;
            $phoneData['Client_name'] = $unit->client->name ?? null;
            $phoneData['Client_email'] = $unit->client->email ?? null;

            $phoneData['Client_phone_1'] = isset($phoneNumbers[0]) ? $phoneNumbers[0]->country->phonecode . ' ' . $phoneNumbers[0]->phone : null;
            $phoneData['Client_phone_2'] = isset($phoneNumbers[1]) ? $phoneNumbers[1]->country->phonecode . ' ' . $phoneNumbers[1]->phone : null;
            $phoneData['Client_phone_3'] = isset($phoneNumbers[2]) ? $phoneNumbers[2]->country->phonecode . ' ' . $phoneNumbers[2]->phone : null;
           
            $phoneData['Client_job_title'] = $unit->client->job_title ?? null;
            $phoneData['Client_civil_date'] = $unit->client->civil_date ?? null;
            $phoneData['Client_civil_city'] = $unit->client->civil_city ?? null;
            $phoneData['Client_civil_number'] = $unit->client->civil_number ?? null;
            $phoneData['Client_civil_address'] = $unit->client->civil_address ?? null;
            $phoneData['Client_created_at'] =  $unit->client->created_at ?? null;
            $phoneData['Client_updated_at'] =  $unit->client->updated_at ?? null;
            $phoneData['Client_nationality'] = $unit->client->nationality ?? null;
            $phoneData['Contract_name'] = $unit->contract->contract->name ?? null;
            $phoneData['Contract_is_delivered'] = $unit->contract->is_delivered ?? null;
            $phoneData['Contract_date'] = $unit->contract->contract_date ?? null;
            $phoneData['Facility_1_price'] = $unit->facilities[0]->price ?? null;
            $phoneData['Facility_1_name'] = $unit->facilities[0]->facility->name ?? null;
            $phoneData['Facility_2_price'] = $unit->facilities[1]->price ?? null;
            $phoneData['Facility_2_name'] = $unit->facilities[1]->facility->name ?? null;
            $phoneData['Facility_3_price'] = $unit->facilities[2]->price ?? null;
            $phoneData['Facility_3_name'] = $unit->facilities[2]->facility->name ?? null;
            $phoneData['Payment_created at'] = $unit->payment->created_at ?? null;
            $phoneData['Payment_updated_at'] = $unit->payment->updated_at ?? null;
            $phoneData['Payment_reservation'] = $unit->payment->reservation ?? null;
            $phoneData['Payment_down_payment'] = $unit->payment->down_payment ?? null;
            $phoneData['Payment_mentainance'] = $unit->payment->mentainance ?? null;
            $phoneData['Payment_total_price'] = $unit->payment->total_price ?? null;
            $phoneData['Payment_total_amount'] = $unit->payment->total_amount ?? null;
            $phoneData['Payment_remaining'] = $unit->payment->remaining ?? null;
            $phoneData['Payment_delivery_date'] = $unit->payment->delivery_date ?? null;

            $reports[] = $phoneData;
        };

        return Excel::download(new ReportsExport($reports), 'Report.xlsx');
    }

    public function DailyCrmReport(Request $request)
    {
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $statuses = Status::get();
        $leadsDaily = Lead::whereBetween('created_at', [$start_date, $end_date])->get();
        $totalLeads = Communication::where('lead_id', 0)->count();

        $leadsData = [];
        $leadsCount = 0;
        $typeCounts = [];

        foreach ($statuses as $statuse) {
            $statusId = $statuse->id;
            $statusName = $statuse->name;
            $count = $leadsDaily->where('status_id', $statusId)->count();

            $leadsData[] = [
                'Status_Name' => $statusName,
                'Count' => "" . $count,
                'Type' => $statuse->type
            ];
            $leadsCount += $count;

            if (isset($typeCounts[$statuse->type])) {
                $typeCounts[$statuse->type] += $count;
            } else {
                $typeCounts[$statuse->type] = $count;
            }
        }

        foreach ($leadsData as &$leadData) {
            $type = $leadData['Type'];
            $leadData['Type_Count'] = $typeCounts[$type];
            $typeCount = $typeCounts[$type];
            $typePercentage = ($typeCount / $leadsCount) * 100;
            $leadData['Type_Percentage'] = round($typePercentage, 2) . '%';
        }

        return Excel::download(new DailyCrmReportExport($leadsData), 'Report.xlsx');
    }

    public function DailySalesReport()
    {
        $statuses = Status::get();
        $date = Carbon::now();
        $leadsDaily = Lead::whereDate('created_at', '=', $date)->get();
        $totalLeads = count($leadsDaily);
        $leadsData = [];
        $leadsCount = 0;

        foreach ($statuses as $statuse) {
            $statusId = $statuse->id;
            $count = $leadsDaily->where('status_id', $statusId)->count();
            $statusName = $statuse->name;

            if ($totalLeads) {
                $leadsData[] = [
                    'Status_Name' => $statusName,
                    'Count' => "" . $count,
                    '%' => $count / $totalLeads * 100 . '%'
                ];
            }

            $leadsCount += $count;
        }

        $excel = new DailySalesReport($leadsData);

        return Excel::download($excel, 'SalesReport.xlsx');
    }

    public function projectsReport(Request $request)
    {
        $start_date = $request->start_date;
        $end_date = $request->end_date;

        $projects = Project::get();
        $leadsDaily = Lead::where('project_id', '!=', 'null')
            ->whereBetween('created_at', [$start_date, $end_date])->get();

        $leadsData = [];
        $leadsCount = 0;

        foreach ($projects as $project) {
            $projectId = $project->id;
            $projectName = $project->name;

            $count = $leadsDaily->where('project_id', $projectId)->count();
            $leadsData[] =
                [
                    'project_Name' => $projectName,
                    'Count' => "" . $count,
                ];

            $leadsCount += $count;
        }

        return Excel::download(new dailyProjectsReportExport($leadsData), 'ProjectsReport.xlsx');
    }

    public function cilReport(Request $request)
    {
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $statuses = Status::get();
        $leadsDaily = Lead::whereBetween('created_at', [$start_date, $end_date])
        ->where('type','cil')
        ->get();

        $totalLeads = Communication::where('lead_id', 0)->count();

        $leadsData = [];
        $leadsCount = 0;
        $typeCounts = [];

        foreach ($statuses as $statuse) {
            $statusId = $statuse->id;
            $statusName = $statuse->name;
            $count = $leadsDaily->where('status_id', $statusId)->count();

            $leadsData[] = [
                'Status_Name' => $statusName,
                'Count' => "" . $count,
                'Type' => $statuse->type
            ];
            $leadsCount += $count;

            if (isset($typeCounts[$statuse->type])) {
                $typeCounts[$statuse->type] += $count;
            } else {
                $typeCounts[$statuse->type] = $count;
            }
        }

        foreach ($leadsData as &$leadData) {
            $type = $leadData['Type'];
            $leadData['Type_Count'] = $typeCounts[$type];
            $typeCount = $typeCounts[$type];
            $typePercentage = ($typeCount / $leadsCount) * 100;
            $leadData['Type_Percentage'] = round($typePercentage, 2) . '%';
        }

        return Excel::download(new CilReportExport($leadsData), 'CilReport.xlsx');
    }
}
