<?php

namespace App\Http\Controllers;

use App\Models\PaymentPlan;
use App\Models\PaymentPlanDetails;
use App\Models\PaymentType;
use Illuminate\Http\Request;

class PaymentPlanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $paymentPlans = PaymentPlan::get();
        return view('paymentPlans.index', compact('paymentPlans'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $paymentTypes = PaymentType::get();
        return view('paymentPlans.create', compact('paymentTypes'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(array_sum($request->amount) != 100){
            return redirect()->back()
            ->with('error','Total Amount has to be 100%');
        }
                
        $plan = new PaymentPlan();
        $plan->name = $request->title;
        $plan->c_method = $request->c_method;
        $plan->type = $request->type;
        $plan->total_years = $request->total_years;
        $plan->save();
 
        if($request->payment_type_id){
            for($i = 0; $i < count($request->payment_type_id); $i++){
                $details = new PaymentPlanDetails();
                $details->payment_plan_id  = $plan->id;
                $details->payment_type_id = $request->payment_type_id[$i];
                $details->amount = $request->amount[$i];
                $details->batch = $request->batch[$i];
                $details->save();
            }
        }
        
        return redirect()->route('paymentPlans.index')
        ->with('success','Payment Plan created successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PaymentPlan  $paymentPlan
     * @return \Illuminate\Http\Response
     */
    public function show(PaymentPlan $paymentPlan)
    {
        //
        return view('paymentPlans.show', compact('paymentPlan'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PaymentPlan  $paymentPlan
     * @return \Illuminate\Http\Response
     */
    public function edit(PaymentPlan $paymentPlan)
    {
        //
        $paymentTypes = PaymentType::get();
        return view('paymentPlans.edit', compact('paymentTypes', 'paymentPlan'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PaymentPlan  $paymentPlan
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PaymentPlan $paymentPlan)
    {
        //
        if(array_sum($request->amount) != 100){
            return redirect()->back()
            ->with('error','Total Amount has to be 100%');
        }
        
        if(count($paymentPlan->projects) == 0){
            
            $paymentPlan->name = $request->title;
            $paymentPlan->c_method = $request->c_method;
            $paymentPlan->type = $request->type;
            $paymentPlan->save();
    
            foreach($paymentPlan->PaymentPlanDetails as $details){
                $details->delete();
            }
    
            if($request->payment_type_id){
                for($i = 0; $i < count($request->payment_type_id); $i++){
                    $details = new PaymentPlanDetails();
                    $details->payment_plan_id  = $paymentPlan->id;
                    $details->payment_type_id = $request->payment_type_id[$i];
                    $details->amount = $request->amount[$i];
                    $details->batch = $request->batch[$i];
                    // $details->count = $request->count[$i];
                    $details->save();
                }
                
            }
            
            return redirect()->route('paymentPlans.show', $paymentPlan->id)
            ->with('success','Payment Plan created successfully.');

        }else{
            return redirect()->back()
            ->with('error',"You Can't update on this plan");
        }
        

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PaymentPlan  $paymentPlan
     * @return \Illuminate\Http\Response
     */
    public function destroy(PaymentPlan $paymentPlan)
    {
        //
        $paymentPlan->delete();
        return redirect()->route('paymentPlans.index')
            ->with('success',"Plan Trashed Successfully");
    }
}