<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Client;
use App\Models\Unit;
use App\Models\Payment;
use App\Http\Requests\PaymentRequest;

class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         
        

        // $payments = Payment::get();

        // dd($payments);
        

        // if(request()->get('status') == 'unPaid'){
        //     $clients = DB::table('clients')->where('signture', 0)->get();
                
        //     }elseif(request()->get('status') == 'inProgress'){
        //     $clients = DB::table('clients')->where('signture', 1)->get();
    
        //     }elseif(request()->get('status') == 'Paid'){
        //     $clients = DB::table('clients')->whereNotNull('deleted_at')->get();
        //     }else{
        //         $clients = Client::get();
        //     }
        // return view('payment.index', compact('payments')); 

    }
    public function newClients()
    {
         
        // $clients = DB::table('clients')->where('signture', 1)->get();
        // // dd($clients);
        // return view('payment.newClients', compact('clients'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $unit_id = request()->unitId;
        // dd($unit_id);
        $unit = Unit::find($unit_id);
        // dd($unit->client->name);
        return view('payment.create', compact('unit'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $unit = Unit::find($request->unit_id);
        $unit->status = $request->status;
        $unit->save();

        foreach($request->payment as $detail)
        {
            $payment = new Payment();
            $payment->description = $detail['description'];
            $payment->amount = $detail['amount'];
            $payment->client_id = $request->client_id;
            $payment->unit_id = $request->unit_id;
            $payment->save();
        }

        return redirect()->route('clients.show', $request->client_id)
        ->with('success','Payment created Successfully');
               
            
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // Show transactions and payment Details

        $payment = Payment::find($id);
        $client = $payment->client()->first();

        $transactions = Payment::find($id)->transactions()->get();;

        return view('payment.show', compact('payment', 'transactions','client'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PaymentRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function PaymentsOfClient($id)
    {
        //
        $client = Client::find($id)->first();
        $payments = Client::find($id)->payment()->get();
        // dd($client);
        return view('payment.PaymentsOfClient' , compact('client', 'payments'));
    }

}