<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;
use App\Http\Resources\LogsActivityResource;
use Redirect;
// use Spatie\QueryBuilder;
use Spatie\QueryBuilder\AllowedFilter;
use App\Models\User;
use Spatie\QueryBuilder\Filters\Filter;
use Illuminate\Database\Eloquent\Builder;

class LogsActivityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $logs = Activity::query();

        if($request->user_id){
            $logs = Activity::whereIn('causer_id',$request->user_id);
        }
        if($request->time1 && $request->time2){
            $logs->whereTime('created_at', '>=',$request->time1)
            ->whereTime('created_at','<=',$request->time2);
        }
        
        if($request->date1 && $request->date2){
            $logs->whereDate('created_at', '>=',$request->date1)
            ->whereDate('created_at','<=',$request->date2);
        }
        $totalLogs = $logs->get();
        $logs = $logs->paginate(50)->withQueryString();
        $users = User::get();
        return view('activity.index', compact('logs','users','totalLogs'));
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    
    public function exportLog(Request $request)
    {
        try{
            $url = str_replace("/public/",'',$request->url);
            $user = User::find($request->userId);
            activity()
                ->causedBy($user)
                ->event('Export')
                ->log($user->name . ' Exported '. $url);
        }catch(Exception $e){
            return $e->getMessage();
        }
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
