<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Models\User;
use App\Models\Agent;
use App\Models\Broker;
use App\Models\Source;
use App\Models\Status;
use App\Models\Country;
use App\Models\InqType;
use App\Models\Inquiry;
use Illuminate\Http\Request;

class InquiryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $inquiries = Inquiry::paginate(50)->withQueryString();
        $brokers = Broker::get();
        $agents = Agent::get();
        $statuses = Status::get();
        $sources = Source::get();
        $inqTypes = InqType::get();
        $users = User::get();
        return view('inquiries.index', compact('inquiries', 'brokers', 'agents', 'statuses', 'sources', 'inqTypes', 'users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return '404';
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $inquiry = new Inquiry();
        $inquiry->title = $request->title;
        $inquiry->number = $request->number;
        $inquiry->location = $request->location;
        $inquiry->description = $request->description;
        $inquiry->broker_id = $request->broker_id;
        $inquiry->agent_id = $request->agent_id;
        $inquiry->status_id = $request->status_id;
        $inquiry->inq_type_id = $request->inq_type_id;
        $inquiry->user_id = $request->user_id;

        if($request->source_id){
            $source = Source::find($request->source_id);
            $inquiry->source_id = $source->id;
            $inquiry->campaign_id = $source->campaign->id;
        }
        $inquiry->save();
        return redirect()->back()->with('success', 'Request Created Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Inquiry  $inquiry
     * @return \Illuminate\Http\Response
     */
    public function show(Inquiry $inquiry)
    {
       
        $lead = Lead::whereInquiryId($inquiry->id)->first();
        // dd($lead->inquiry);
        $broker = Broker::find($inquiry->broker_id);
        $agents = $broker->agents;
        $statuses = Status::get();
        $sources = Source::get();
        $inqTypes = InqType::get();
        $users = User::get();
        $countries = Country::get();
        return view('inquiries.show', compact('inquiry','countries', 'agents', 'statuses', 'sources', 'inqTypes', 'users'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Inquiry  $inquiry
     * @return \Illuminate\Http\Response
     */
    public function edit(Inquiry $inquiry)
    {
        //
        return '404';
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Inquiry  $inquiry
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Inquiry $inquiry)
    {
        //
        $inquiry->title = $request->title;
        $inquiry->number = $request->number;
        $inquiry->location = $request->location;
        $inquiry->description = $request->description;
        $inquiry->broker_id = $request->broker_id;
        $inquiry->agent_id = $request->agent_id;
        $inquiry->status_id = $request->status_id;
        $inquiry->inq_type_id = $request->inq_type_id;
        $inquiry->user_id = $request->user_id;

        if($request->source_id){
            $source = Source::find($request->source_id);
            $inquiry->source_id = $source->id;
            $inquiry->campaign_id = $source->campaign->id;
        }
        $inquiry->save();
        return redirect()->back()->with('success', 'Request Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Inquiry  $inquiry
     * @return \Illuminate\Http\Response
     */
    public function destroy(Inquiry $inquiry)
    {
        //
        return '404';
    }

    public function inquiryReAssign(Request $request)
    {
        // dd($request);
        $inquiry = Inquiry::find($request->inquiry_id);
        $inquiry->user_id = $request->user_id;
        $inquiry->save();

        // $users = User::get();
        // $CurrentUser = auth()->user();
        // activity()
        // ->performedOn($communication)
        // ->causedBy($CurrentUser)
        // ->event('Activity Check In')
        // ->withProperties([
        //     'activity_creator_name' => $CurrentUser->name,
        //     'activity_creator_id' => $CurrentUser->id,
        //     'activity_type' => 're-assign user',
        //     'broker_name' => $communication->broker->name,
        //     'broker_id' => $communication->broker->id,
        //     'communication_id' => $communication->id,
        // ])
        // ->log($CurrentUser->name . ' Re-Assigned Activity to : (' . $communication->user->name . ')');

        return redirect()->back()->with('success', 'user changed successfully');
    }
}
