<?php

namespace App\Http\Controllers;

use App\Models\InqType;
use Illuminate\Http\Request;

class InqTypeController extends Controller
{
    public function index()
    {
        //
        return '404';
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $inqTypes = InqType::get();
        return view('inqTypes.create', compact('inqTypes'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inqTypes = InqType::pluck('name');
    
        $fCount = count($inqTypes);
        $rCount = count($request->name);

        if($rCount >= $fCount){
            for ($i=0; $i<$rCount; $i++) {
                InqType::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                );
            }
        }

        $user = auth()->user();
         activity()
         ->event('create')
         ->log($user->name .' created Request Types');
        return redirect()->back()->with('success', 'Request Types updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\InqType  $inqType
     * @return \Illuminate\Http\Response
     */
    public function destroy(InqType $inqType)
    {
        //
        $inqType->delete();
        return redirect()->back()->with('success', 'Request Types Trashed Successfully');
    }
}
