<?php

namespace App\Http\Controllers;
use App\Models\Facility;
use Illuminate\Http\Request;

class FacilityController extends Controller
{
    

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $facilities = Facility::get();
        return view('facilities.create', compact('facilities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validated = $request->validate([
            'name' => 'required|unique:facilities',
        ]);

        $count = count($request->name);

        for ($i = 0; $i<$count; $i++) {
                Facility::create(
                    [
                        'name' => $request->name[$i],
                    ]
                );
        }

         $user = auth()->user();
         activity()
         ->event('update')
         ->log($user->name .' updated facilities');
        return redirect()->back()->with('success', 'Facilities created Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Facility $facility)
    {
        //
        $facility->delete();
        return redirect()->back()->with('success', 'Facilities Removed Successfully');

    }
}
