<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Lead;
use App\Models\Client;
use App\Models\Alert;
use App\Models\Communication;
use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $usersCount = count(User::all());
        $clientsCount = count(Client::all());

        if (auth()->user()->hasRole('SuperAdmin')) {
            $leadsCount = count(Lead::all());
            $communicationsCount = count(Communication::all());
        } else {
            $leadsCount = count(Lead::where('user_id', auth()->user()->id)->get());
            $communicationsCount = count(Communication::where('user_id', auth()->user()->id)->get());
        }

        $leadsDaily = Lead::query();
        $date = Carbon::now();
        $leadsDaily->whereDate('created_at', '=', $date);
        
        $leadsMonthly = Lead::query();
        $currentDate = Carbon::now();
        $currentDate->addDays(1)->toDateString();
        $lastMonth = Carbon::now()->subMonth()->toDateString();
        $leadsMonthly->whereBetween('created_at',  [$lastMonth, $currentDate]);
        
        if(auth()->user()->type == "admin" || auth()->user()->role == "Sales Admin")
        {
            $leadsDaily = $leadsDaily->get();
            $leadsMonthly = $leadsMonthly->get();
        }else
        {
            $childUsers = auth()->user()->allChildren()->pluck('id')->toArray();
            if(count($childUsers) > 0){
                $leadsDaily = $leadsDaily->where(function ($query) {
                            $query->where('created_by', auth()->user()->id)
                                ->orWhereIn('user_id', auth()->user()->allChildren()->pluck('id')->toArray());
                        });
                $leadsMonthly = $leadsMonthly->where(function ($query) {
                    $query->where('created_by', auth()->user()->id)
                        ->orWhereIn('user_id', auth()->user()->allChildren()->pluck('id')->toArray());
                });
            }else{
                $leadsDaily = $leadsDaily->where('created_by',auth()->user()->id);
                $leadsMonthly = $leadsMonthly->where('created_by',auth()->user()->id);
            }
            
            $leadsDaily = $leadsDaily->get();
            $leadsMonthly = $leadsMonthly->get();
        }
        $statuses = Status::get();

        return view('home', compact('statuses', 'leadsDaily', 'leadsMonthly', 'usersCount', 'clientsCount', 'leadsCount', 'communicationsCount'));
    }

    // 

}
