<?php

namespace App\Http\Controllers;
use App\Models\Contract;
use App\Models\Client;
use App\Models\Unit;
use App\Models\Payment;
use App\Models\ClientContract;
use App\Models\FacilityUnit;
use App\Models\Facility;
use App\Models\Code;
use Carbon\Carbon;

use Illuminate\Http\Request;

class ContractController extends Controller
{
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $contracts = Contract::get();
        $user = auth()->user();
            activity()
                    ->event('visit')
                    ->log($user->name .'Visited Contracts page');
        return view('contracts.index', compact('contracts'));
    }

    public function ClientContracts()
    {
        //
        $contracts = ClientContract::get();
        $user = auth()->user();
            activity()
                    ->event('visit')
                    ->log($user->name .'Visited Client Contracts page');
        return view('contracts.clientContracts', compact('contracts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $codes = Code::get();
        $user = auth()->user();
            activity()
                    ->event('visit')
                    ->log($user->name .' just Create contract page');
        return view('contracts.create', compact('codes'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->body);
        $contract = new Contract();
        $contract->name = $request->name ?? '';
        $contract->type = $request->type ?? '';
        $contract->body = $request->body ?? '';
        $contract->save();

        $user = auth()->user();
            activity()
                    ->event('Create')
                    ->log($user->name .' just Created New Contract' . $contract->name ?? '');

        return redirect()->route('contracts.show', $contract->id)
                        ->with('success','Contract Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Contract $contract)
    {
        //
        $user = auth()->user();
            activity()
                    ->event('visit')
                    ->log($user->name .' just visited ' . $contract->name . ' page');
        return view('contracts.show', compact('contract'));
    }


    // Print Contract
    public function printContract($id)
    {   
        $unit_contract = ClientContract::find($id);
        
        return view('units.printContract', compact('unit_contract'));
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Contract $contract)
    {
        //
        $codes = Code::get();

        $user = auth()->user();
            activity()
                    ->event('visit')
                    ->log($user->name .' just visited ' . $contract->name . ' Editing page');
        return view('contracts.edit', compact('contract', 'codes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Contract $contract)
    {
        //
        $contract->name = $request->name;
        $contract->type = $request->type;
        $contract->body = $request->body;
        $contract->save();

        $user = auth()->user();
            activity()
                    ->event('update')
                    ->log($user->name .' just updated ' . $contract->name);

        return redirect()->route('contracts.show', $contract->id)
                        ->with('success','Contract updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Contract $contract)
    {
        $user = auth()->user();
            activity()
                    ->event('update')
                    ->log($user->name .' just deleted contract' . $contract->name ?? '');
        $contract->delete();
        return redirect()->route('contracts.index')
                        ->with('success','Contract Deleted Successfully');
    }


    public function unitContract($unitId, $clientId)
    {
        $client = Client::find($clientId);
        $unit = Unit::find($unitId);

        $contracts = Contract::get();
        $payment = Payment::where('unit_id', $unitId)->first();
        $u_facilities = FacilityUnit::where('unit_id', $unit->id)->get();

        $facilities = array();
        
        for($i=0; $i< count($u_facilities); $i++){
            $facility = Facility::find($u_facilities[$i]['facility_id']);
            array_push($facilities, [
                'name'=> $facility->name,
                'price'=>$u_facilities[$i]['price'],
                'price_word' => $u_facilities[$i]['price_word'],
            ]);
        }
        return view('clients.contract', compact('contracts', 'unit', 'client', 'payment', 'facilities'));
    }

    public function generateContract(Request $request)
    {
        // dd($request);
        $contract = Contract::find($request->contract);
        $unit = Unit::find($request->unit_id);

        $client = Client::find($request->client_id);
        $GarageFacility = Facility::find(1);
        $garage = FacilityUnit::where(['unit_id'=> $unit->id, 'facility_id' => 1])->first();
        // dd($garage);
        $garage_name = $GarageFacility->name ?? '';
        $garage_price = $garage->price ?? '';
        $garage_price_word = $garage->price_word ?? '';
        // $ph_data = array();
        
        // for($i=0; $i< count($client->phones); $i++){
        //     $phones = Facility::find($u_facilities[$i]['facility_id']);
        //     array_push($f_data, [
        //         'name'=>$facility->name,
        //         'price'=>$u_facilities[$i]['price'],
        //         'price_word' => $u_facilities[$i]['price_word'],
        //     ]);
        // }
        $phones = '';
        foreach($client->phone_numbers as $data){
            $phones .= '+'. $data->country->phonecode . ' ' .$data->phone . ' / ';
        }

// dd($phones);
        $newBody = $contract->body;

        $c_date = str_replace('-','/', $request->C_date);
        $newBody = str_replace('c_date',$c_date,$newBody);

        $unit->status = $request->status;
        $unit->save();
        


        foreach ($request->except('_token') as $key => $value) {
            if($key == 'deal_price' || $key == 'total_amount' || $key == 'total_remaining'){
                $newBody = str_replace('<span dir="LTR">'.$key.'</span>','<span dir="LTR">'.$value.'</span>',$newBody);
            }else{
                $newBody = str_replace($key,$value,$newBody);
            }
        }
        $break = '';

        $c_date = Carbon::create($request->C_date);
        $c_date_formate = $c_date->isoFormat('dddd');
        $c_day = '';
        
        switch ($c_date_formate) {
            case 'Saturday': $c_day = 'السبت'; break;
            case 'Sunday': $c_day = 'الاحد'; break;
            case 'Monday': $c_day = 'الاثنين'; break;
            case 'Tuesday': $c_day = 'الثلاثاء'; break;
            case 'Wednesday': $c_day = 'الاربعاء'; break;
            case 'Thursday': $c_day = 'الخميس'; break;
            case 'Friday': $c_day = 'الجمعه'; break;
        }

        // dd($c_day);
        $newBody = str_replace('c_day',$c_day,$newBody);
        $newBody = str_replace('-','',$newBody);
        $newBody = str_replace('break','<div id="page-break"></div>',$newBody);
        $newBody = str_replace('garage_name',$garage_name,$newBody);
        $newBody = str_replace('garage_price',$garage_price,$newBody);
        $newBody = str_replace('garage_word',$garage_price_word,$newBody);
        $newBody = str_replace('phones','<span dir="LTR">'.$phones.'</span>',$newBody);
        $newBody = str_replace('(','',$newBody);
        $newBody = str_replace(')','',$newBody);
         
        $clientContract = new ClientContract();
        $clientContract->client_id = $client->id;
        $clientContract->unit_id = $unit->id;
        $clientContract->contract_id = $contract->id;
        $clientContract->body = $newBody;
        $clientContract->contract_date = $request->C_date;
        
        $clientContract->save();

        $batches = $unit->batches;
        $project = $unit->building->phase->project;
        $m_date = new Carbon($request->C_date); // Maintainance batches start date
        $tu_date = new Carbon($request->C_date); // Total Unit batches start date

        foreach($batches as $batch){
            if($batch->type == 'total_unit'){
                if($batch->title == 'DownPayment'){
                    $m_date = $m_date;
                }
                if($batch->title == 'monthly'){
                    $m_date = $m_date->addMonth();

                }
                if($batch->title == 'quarterly'){
                    $m_date = $m_date->addMonths(3);
                }
                if($batch->title == 'yearly'){
                    $m_date = $m_date->addYear();
                }

                $batch->date = $m_date;
            }else{
                if($batch->title == 'monthly'){
                    $tu_date = $tu_date->addMonth();
                }
                if($batch->title == 'quarterly'){
                    $tu_date = $tu_date->addMonths(3);
                }
                if($batch->title == 'yearly'){
                    $tu_date = $tu_date->addYear();
                }

                $batch->date = $tu_date;
            }
            
            $batch->save();
        }

        $user = auth()->user();
        $Model = new Unit();
        activity()
        ->performedOn($Model)
        ->causedBy($user)
        ->event('Unit Actions')
        ->withProperties([
            'unit_id' => $unit->id,
            'client_id' => $client->id,
        ])
        ->log('The unit (' . $unit->name .') Main Contract has been Generated For Client '. $client->name);       
        return view('contracts.print', compact('newBody'));
    }

    public function ContractDelivered($id)
    {   
        $unit_contract = ClientContract::find($id);
        
        $client = Client::find($unit_contract->client_id);
        $unit = Unit::find($unit_contract->unit_id);

        $unit_contract->is_delivered = 1;
        $unit_contract->save();

        $Model = new Client(); 
        activity()
        ->performedOn($Model)
        ->causedBy($user)
        ->event('Client Actions')
        ->withProperties([
            'unit_id' => $unit->id,
            'client_id' => $client->id,
        ])
        ->log('The Client (' . $client->name .') Recieved the main Contract of the Unit (' . $unit->name . ')'); 


        return redirect()->back()->with('success','Contract Created Successfully');
    }


    
    public function archive()
    {        
        $contracts = Contract::onlyTrashed()->get();
        
        // Log activity
        $model = new Contract();
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Visit - Contract archive')
            ->log(auth()->user()->name .' viewed Contracts archive');

        return view('contracts.archive',compact('contracts'));
    }

    public function restore($cContractId)
    {
        ClientContract::withTrashed()->find($cContractId)->restore();
        $contract = ClientContract::find($cContractId);

        // $user = auth()->user();
            
        // activity()
        // ->performedOn($phase)
        // ->causedBy($user)
        // ->event('Restore phase')
        // ->log('Phase (' . $phase->name . ') Restored by '. $user->name);


        return redirect()->back();
    }

    public function restoreAll()
    {
        ClientContract::onlyTrashed()->restore();

        // $phase = new Phase();
        // $user = auth()->user();
            
        // activity()
        // ->performedOn($phase)
        // ->causedBy($user)
        // ->event('Restore All phases')
        // ->log('All phase Restored by '. $user->name);

        return redirect()->back();
    }
}