<?php

namespace App\Http\Controllers;
use App\Models\File;
use App\Models\User;
use App\Models\Action;
use App\Models\Client;
use App\Models\Ticket;
use App\Models\Comment;
use Illuminate\Http\Request;
use App\Http\Requests\CommentRequest;

class CommentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // 
        $comment = new Comment();
        $comment->status = $request->comment_status;
        $comment->description = $request->description;
        $comment->created_by = $request->created_by;
        $comment->ticket_id = $request->ticket_id;
        $comment->save();

        // store files
        if(isset($request['files'])){
            for($i=0; $i < count($request['files']); $i++){
            
                $imageName = time().'.'.$request['files'][$i]->extension();  
                $request['files'][$i]->move(public_path('images'), $imageName);
          
                /* Store $imageName name in DATABASE from HERE */
                $file = new File();
                $file->comment_id = $comment->id;
                $file->file = $imageName;
                $file->save();
            }
        }

        $ticket = Ticket::find($comment->ticket_id);
        $user = auth()->user();

        // Store Action
        $action = new Action();
        $action->ticket_id = $ticket->id;
        $action->client_id = $ticket->client_id;
        $action->unit_id = $ticket->unit_id;
        $action->user_id = $user->id;
        $action->action_type = 'Note';
        $action->details = $user->name . " Created Note " . ($comment->description);
        
        if(isset($ticket->user_id)){
            $assigned_user = User::find($ticket->user_id);
            $action->assigned_user_id = $assigned_user->id;
            $action->assigned_user_name = $assigned_user->name;
        }

        $action->save();

        activity()
        ->performedOn($ticket)
        ->causedBy($user)
        ->event('Note')
        ->log($user->name .' Wrote a Comment ('.$comment->description.') on Ticket ' . $ticket->id . ' That Belongs To Client ' . $ticket->client->name . ' About Unit ' . $ticket->unit->name);


        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CommentRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
