<?php

namespace App\Http\Controllers\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Requests\PermissionRequest;
use App\Models\Permission;
use App\Models\Role;
use App\Models\User;
use Exception;
use Illuminate\Support\Arr;

class PermissionController extends Controller
{
    public function __construct()
    {
        // $this->middleware('permission:permissions-create');
        // $this->middleware('permission:permissions-read');
        // $this->middleware('permission:permissions-update');
        // $this->middleware('permission:permissions-delete');
    }

    public function index()
    {
        $users = User::get();
        $roles = Role::get();
        $permissions = Permission::get();
        return view('permissions.index', compact('permissions', 'roles', 'users'));
    }

    public function create()
    {
        return view('permissions.create');
    }

    public function store(PermissionRequest $request)
    {
        try {
            DB::beginTransaction();
            $permission = new Permission();
            $permission->name = str_replace(' ', '-', strtolower($request->name));
            $permission->display_name = ucwords($request->name);
            $permission->description = $request->description;
            $permission->save();
            DB::commit();

            activity()
                ->event('create')
                ->log(auth()->user()->name . ' added new permissions ');

            return redirect()->route('index.permissions')->with('success', 'Permission Created Successfully');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit($permissionId)
    {
        $permission = Permission::findOrFail($permissionId);
        return view('permissions.edit', compact('permission'));
    }

    public function update(PermissionRequest $request, $permissionId)
    {
        $permission = Permission::findOrFail($permissionId);
        try {
            DB::beginTransaction();
            $permission->name = str_replace(' ', '-', strtolower($request->name));
            $permission->display_name = ucwords($request->name);
            $permission->description = $request->description;
            $permission->save();
            DB::commit();

            return redirect()->route('index.permissions')->with('success', 'Permission Updated Successfully');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function show($permissionId)
    {
        $permission = Permission::findOrFail($permissionId);
        return view('permissions.show', compact('permission'));
    }

    public function destroy($permissionId)
    {
        $permission = Permission::findOrFail($permissionId);
        $permission->delete();
        return redirect()->route('index.permissions')->with('success', 'Permission Deleted Successfully');
    }

    public function addPermission(Request $request)
    {
        $permissions = $request->permissions;
        $user = User::findOrFail($request->userId);
        if ($permissions != null) {
            $user->syncPermissions($permissions);
        } else {
            $user->detachPermissions($user->permissions()->pluck('id')->toArray());
        }

        return response()->json([
            'message' => 'Permissions Updated Successfully',
        ]);
    }

    public function getUserPermissions($userId)
    {
        $user = User::find($userId);

        if ($user) {
            $permissions = $user->permissions()->pluck('id')->toArray();
            return response()->json($permissions);
        }

        return response()->json([], 404);
    }


    public function addRolePermission(Request $request)
    {
        $permissions = $request->permissions;
        $role = Role::findOrFail($request->roleId);

        if ($permissions != null) {
            $role->syncPermissions($permissions);
        } else {
            $role->detachPermissions($role->permissions()->pluck('id')->toArray());
        }

        return response()->json([
            'message' => 'Roles Updated Successfully',
        ]);
    }

    public function getRolePermissions($roleId)
    {
        $role = Role::find($roleId);

        if ($role) {
            $permissions = $role->permissions()->pluck('id')->toArray();
            return response()->json($permissions);
        }

        return response()->json([], 404);
    }
}
