<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ReportsExport implements FromCollection, WithHeadings
{
    protected $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return collect($this->data);
    }

    public function headings(): array
    {
        return [
            'Project_Name',
            'Unit_ID',
            'Unit_name',
            'Unit_floor',
            'Unit_unit_space',
            'Unit_unit_meter_price',
            'Unit_unit_total_price',
            'Unit_roof_total_price',
            'Unit_garden_space',
            'Unit_garden_total_price',
            'Unit_bedrooms',
            'Unit_bathrooms',
            'Unit_Booked_date',
            'Unit_is_active',
            'Unit_user_name',
            'Unit_client_name',
            'Unit_building_name',
            'Unit_type',
            'Unit_finishing',
            'Unit_view',
            'Unit_status',
            'Unit_created_at',
            'Unit_updated_at',
            'Unit_dressing',
            'Unit_description',
            'Unit_roof_space',
            'Client_ID',
            'Client_name',
            'Client_email',
            'Client_phone_1',
            'Client_phone_2',
            'Client_phone_3',
            'Client_job_title',
            'Client_civil_date',
            'Client_civil_city',
            'Client_civil_number',
            'Client_civil_address',
            'Client_created_at',
            'Client_updated_at',
            'Client_nationality',
            'Contract_name',
            'Contract_is_delivered',
            'Contract_date',
            'Facility_1_price',
            'Facility_1_name',
            'Facility_2_price',
            'Facility_2_name',
            'Facility_3_price',
            'Facility_3_name',
            'Payment_created at',
            'Payment_updated_at',
            'Payment_reservation',
            'Payment_down_payment',
            'Payment_mentainance',
            'Payment_total_price',
            'Payment_total_amount',
            'Payment_remaining',
            'Payment_delivery_date',
        ];
    }
}
