<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Ticket;
use App\Models\Alert;
use Carbon\Carbon;

class TicketDeadline extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ticket:deadline';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'check deadline of tickets';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Compare now with deadline
        // return 'some';
        try{
            $tickets = Ticket::where('status','!=','done')->get();
            foreach($tickets as $ticket){
                $today = Carbon::today();
                $deadline =  Carbon::create($ticket->deadline);
                if($today <= $ticket->deadline){
                    if($today == $deadline->subDay()){ 
                        
                        //   send alert here to user
                        $user = User::find($ticket->user_id);
                        $alert = new Alert();
                        $alert->user_id = $user->id;
                        $alert->ticket_id = $ticket->id;
                        $alert->title = "Ticket(" .$ticket->id. ")";
                        $alert->body = "don't miss it, you have to take action";
                        $alert->type = 'Ticket';
                        $alert->save();
    
                    }
                }elseif($today >= $deadline->addDay()){
                     $ticket->delay = 1;
                     $ticket->save();
    
                     $user = User::find($ticket->user_id);
    
                     if($user->assigned_to != null){
                         $leader = User::find($user->assigned_to);
                     }else{
                         $leader = User::find(1);
                     }


                     $user = User::find($ticket->user_id);
                        $alert = new Alert();
                        $alert->user_id = $leader->id;
                        $alert->ticket_id = $ticket->id;
                        $alert->title = "Ticket(" .$ticket->id. ")";
                        $alert->body = "Ticket of user (" . $leader->name . ") that belongs to (".$ticket->unit->name.") missed the deadline";
                        $alert->type = 'Ticket';
                        $alert->save();

                }
    
            }
        }catch(Exception $e){
            \Log::info($e->getMessage());
        }
        
    }
}
